/*
 * Decompiled with CFR 0.152.
 */
package io.atlasmap.itests.core;

import io.atlasmap.api.AtlasContext;
import io.atlasmap.api.AtlasSession;
import io.atlasmap.core.DefaultAtlasContextFactory;
import io.atlasmap.itests.core.BaseClass;
import io.atlasmap.itests.core.SourceClass;
import io.atlasmap.itests.core.TargetClass;
import io.atlasmap.itests.core.TestHelper;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.net.URL;
import java.nio.file.Files;
import java.nio.file.Paths;
import java.util.ArrayList;
import org.junit.Assert;
import org.junit.Test;

public class ExpressionTest {
    @Test
    public void testFilterSelectJava() throws Exception {
        URL url = Thread.currentThread().getContextClassLoader().getResource("mappings/atlasmapping-expression-filter-select-java.json");
        AtlasContext context = DefaultAtlasContextFactory.getInstance().createContext(url.toURI());
        AtlasSession session = context.createSession();
        ArrayList<BaseClass.SomeNestedClass> sourceList = new ArrayList<BaseClass.SomeNestedClass>();
        for (int i = 0; i < 5; ++i) {
            BaseClass.SomeNestedClass s = new BaseClass.SomeNestedClass();
            s.setSomeField("v" + i);
            sourceList.add(s);
        }
        SourceClass source = new SourceClass();
        source.setSomeArray(sourceList.toArray(new BaseClass.SomeNestedClass[0]));
        session.setSourceDocument("SourceClass", (Object)source);
        context.process(session);
        Assert.assertFalse((String)TestHelper.printAudit(session), (boolean)session.hasErrors());
        Object output = session.getTargetDocument("TargetClass");
        Assert.assertEquals(TargetClass.class, output.getClass());
        TargetClass target = (TargetClass)TargetClass.class.cast(output);
        BaseClass.SomeNestedClass[] array = target.getSomeArray();
        Assert.assertEquals((long)4L, (long)array.length);
        Assert.assertEquals((Object)"v0", (Object)array[0].getSomeField());
        Assert.assertEquals((Object)"v2", (Object)array[1].getSomeField());
    }

    @Test
    public void testFilterSelectJson() throws Exception {
        URL url = Thread.currentThread().getContextClassLoader().getResource("mappings/atlasmapping-expression-filter-select-json.json");
        AtlasContext context = DefaultAtlasContextFactory.getInstance().createContext(url.toURI());
        AtlasSession session = context.createSession();
        String sourceJson = new String(Files.readAllBytes(Paths.get(Thread.currentThread().getContextClassLoader().getResource("data/json-source-expression-filter-select.json").toURI())));
        session.setSourceDocument("json-source", (Object)sourceJson);
        context.process(session);
        Assert.assertFalse((String)TestHelper.printAudit(session), (boolean)session.hasErrors());
        Object output = session.getTargetDocument("TargetClass");
        Assert.assertEquals(TargetClass.class, output.getClass());
        TargetClass target = (TargetClass)TargetClass.class.cast(output);
        BaseClass.SomeNestedClass[] array = target.getSomeArray();
        Assert.assertEquals((long)4L, (long)array.length);
        Assert.assertEquals((Object)"v0", (Object)array[0].getSomeField());
        Assert.assertEquals((Object)"v2", (Object)array[1].getSomeField());
    }

    @Test
    public void testFilterSelectXml() throws Exception {
        URL url = Thread.currentThread().getContextClassLoader().getResource("mappings/atlasmapping-expression-filter-select-xml.json");
        AtlasContext context = DefaultAtlasContextFactory.getInstance().createContext(url.toURI());
        AtlasSession session = context.createSession();
        String sourceXml = new String(Files.readAllBytes(Paths.get(Thread.currentThread().getContextClassLoader().getResource("data/xml-source-expression-filter-select.xml").toURI())));
        session.setSourceDocument("xml-source", (Object)sourceXml);
        context.process(session);
        Assert.assertFalse((String)TestHelper.printAudit(session), (boolean)session.hasErrors());
        Object output = session.getTargetDocument("TargetClass");
        Assert.assertEquals(TargetClass.class, output.getClass());
        TargetClass target = (TargetClass)TargetClass.class.cast(output);
        BaseClass.SomeNestedClass[] array = target.getSomeArray();
        Assert.assertEquals((long)4L, (long)array.length);
        Assert.assertEquals((Object)"v0", (Object)array[0].getSomeField());
        Assert.assertEquals((Object)"v2", (Object)array[1].getSomeField());
    }

    @Test
    public void testAction() throws Exception {
        URL url = Thread.currentThread().getContextClassLoader().getResource("mappings/atlasmapping-expression2-action.json");
        AtlasContext context = DefaultAtlasContextFactory.getInstance().createContext(url.toURI());
        AtlasSession session = context.createSession();
        SourceClass source = new SourceClass();
        source.setSomeIntArray(new int[]{1, 2, 3, 4, 5});
        source.setSomeStringArray(new String[]{"one", "two", "three", "four"});
        session.setSourceDocument("SourceClass", (Object)source);
        context.process(session);
        Assert.assertFalse((String)TestHelper.printAudit(session), (boolean)session.hasErrors());
        Object output = session.getTargetDocument("TargetClass");
        Assert.assertEquals(TargetClass.class, output.getClass());
        TargetClass target = (TargetClass)TargetClass.class.cast(output);
        Assert.assertEquals((double)3.0, (double)target.getSomeDouble(), (double)0.01);
        Assert.assertArrayEquals((Object[])new String[]{"ONE", "TWO", "THREE", "FOUR"}, (Object[])target.getSomeStringArray());
    }

    @Test
    public void testCompare() throws Exception {
        URL url = Thread.currentThread().getContextClassLoader().getResource("mappings/atlasmapping-expression2-compare.json");
        AtlasContext context = DefaultAtlasContextFactory.getInstance().createContext(url.toURI());
        AtlasSession session = context.createSession();
        SourceClass source = new SourceClass();
        source.setSomeBigDecimal(new BigDecimal("1"));
        source.setSomeBigInteger(new BigInteger("2"));
        source.setSomeLong(3L);
        source.setSomeDouble(4.0);
        session.setSourceDocument("SourceClass", (Object)source);
        context.process(session);
        Assert.assertFalse((String)TestHelper.printAudit(session), (boolean)session.hasErrors());
        Object output = session.getTargetDocument("TargetClass");
        Assert.assertEquals(TargetClass.class, output.getClass());
        TargetClass target = (TargetClass)TargetClass.class.cast(output);
        Assert.assertEquals((Object)"3", (Object)target.getSomeField());
        Assert.assertEquals((Object)"3", (Object)target.getSomeString());
        Assert.assertEquals((long)10L, (long)target.getSomeInt());
    }

    @Test
    public void testPlus() throws Exception {
        URL url = Thread.currentThread().getContextClassLoader().getResource("mappings/atlasmapping-expression2-oper.json");
        AtlasContext context = DefaultAtlasContextFactory.getInstance().createContext(url.toURI());
        AtlasSession session = context.createSession();
        SourceClass source = new SourceClass();
        source.setSomeField("first");
        source.setSomeString("second");
        session.setSourceDocument("SourceClass", (Object)source);
        context.process(session);
        Assert.assertFalse((String)TestHelper.printAudit(session), (boolean)session.hasErrors());
        Object output = session.getTargetDocument("TargetClass");
        Assert.assertEquals(TargetClass.class, output.getClass());
        TargetClass target = (TargetClass)TargetClass.class.cast(output);
        Assert.assertEquals((Object)"firstsecond", (Object)target.getSomeField());
    }
}

