/*
 * Decompiled with CFR 0.152.
 */
package io.atlasmap.itests.core.issue;

import io.atlasmap.api.AtlasContext;
import io.atlasmap.api.AtlasSession;
import io.atlasmap.core.DefaultAtlasContextFactory;
import io.atlasmap.itests.core.TestHelper;
import java.net.URL;
import java.nio.file.Files;
import java.nio.file.Paths;
import java.util.HashMap;
import org.junit.Assert;
import org.junit.Test;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.xmlunit.assertj.XmlAssert;

public class ENTESB15747Test {
    private static final Logger LOG = LoggerFactory.getLogger(ENTESB15747Test.class);

    @Test
    public void test() throws Exception {
        URL url = Thread.currentThread().getContextClassLoader().getResource("mappings/issue/entesb-15747-mapping.json");
        AtlasContext context = DefaultAtlasContextFactory.getInstance().createContext(url.toURI());
        AtlasSession session = context.createSession();
        URL in1 = Thread.currentThread().getContextClassLoader().getResource("data/issue/entesb-15747-source1.json");
        String source1 = new String(Files.readAllBytes(Paths.get(in1.toURI())));
        URL in2 = Thread.currentThread().getContextClassLoader().getResource("data/issue/entesb-15747-source2.json");
        String source2 = new String(Files.readAllBytes(Paths.get(in2.toURI())));
        session.setSourceDocument("-MT5ptb_dciq61nmn53T", (Object)source1);
        session.setSourceDocument("-MT5pxPYdciq61nmn53T", (Object)source2);
        context.process(session);
        Assert.assertFalse((String)TestHelper.printAudit(session), (boolean)session.hasErrors());
        Object target = session.getTargetDocument("-MT5pwFQdciq61nmn53T");
        Assert.assertNotNull((Object)target);
        LOG.info(target.toString());
        HashMap<String, String> namespaces = new HashMap<String, String>();
        namespaces.put("tns", "http://hl7.org/fhir");
        XmlAssert targetAssert = XmlAssert.assertThat((Object)target).withNamespaceContext(namespaces);
        targetAssert.valueByXPath("//tns:Transaction/tns:Patient/tns:id/@tns:value").isEqualTo((Object)"ls1 ls2 ls3");
        targetAssert.valueByXPath("//tns:Transaction/tns:Patient/tns:name[1]/tns:given/@tns:value").isEqualTo((Object)"fn1");
        targetAssert.valueByXPath("//tns:Transaction/tns:Patient/tns:name[2]/tns:given/@tns:value").isEqualTo((Object)"fn2");
        targetAssert.valueByXPath("//tns:Transaction/tns:Patient/tns:name[3]/tns:given/@tns:value").isEqualTo((Object)"fn3");
        targetAssert.valueByXPath("//tns:Transaction/tns:Patient/tns:name[1]/tns:family/@tns:value").isEqualTo((Object)"ln1");
        targetAssert.valueByXPath("//tns:Transaction/tns:Patient/tns:name[2]/tns:family/@tns:value").isEqualTo((Object)"ln2");
        targetAssert.valueByXPath("//tns:Transaction/tns:Patient/tns:name[3]/tns:family/@tns:value").isEqualTo((Object)"ln3");
        targetAssert.valueByXPath("//tns:Transaction/tns:Basic/tns:id/@tns:value").isEqualTo((Object)"1 2 3");
        targetAssert.valueByXPath("//tns:Transaction/tns:Basic/tns:language/@tns:value").isEqualTo((Object)"t1 t2 t3");
    }
}

