/*
 * Decompiled with CFR 0.152.
 */
package io.atlasmap.itests.core.issue;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.node.ArrayNode;
import io.atlasmap.api.AtlasContext;
import io.atlasmap.api.AtlasSession;
import io.atlasmap.core.DefaultAtlasContextFactory;
import io.atlasmap.itests.core.TestHelper;
import java.net.URL;
import java.nio.file.Files;
import java.nio.file.Paths;
import org.junit.Assert;
import org.junit.Test;

public class MultiplicityTransformationRepeatConstantTest {
    @Test
    public void testRepeatConstant() throws Exception {
        URL url = Thread.currentThread().getContextClassLoader().getResource("mappings/issue/atlasmapping-multiplicity-transformation-action-repeat-constant.json");
        AtlasContext context = DefaultAtlasContextFactory.getInstance().createContext(url.toURI());
        AtlasSession session = context.createSession();
        String sourceJson = new String(Files.readAllBytes(Paths.get(Thread.currentThread().getContextClassLoader().getResource("data/issue/json-source-repeat-constant.json").toURI())));
        session.setSourceDocument("JSONSchemaSource-9c57df5a-9511-411a-a8a9-ce232fc8f3f6", (Object)sourceJson);
        context.process(session);
        Assert.assertFalse((String)TestHelper.printAudit(session), (boolean)session.hasErrors());
        Object output = session.getTargetDocument("JSONSchemaSource-3ddde8cd-f588-4fd4-a996-75c048c648ea");
        JsonNode root = new ObjectMapper().readTree((String)output);
        ArrayNode addrs = (ArrayNode)root.get("addressList");
        Assert.assertEquals((long)5L, (long)addrs.size());
        for (int i = 0; i < addrs.size(); ++i) {
            JsonNode addr = addrs.get(i);
            Assert.assertEquals((Object)"constant-test", (Object)addr.get("city").textValue());
            if (i < 3) {
                Assert.assertEquals((Object)"constant-test", (Object)addr.get("state").textValue());
                continue;
            }
            Assert.assertNull((Object)addr.get("state"));
        }
    }
}

