/*
 * Decompiled with CFR 0.152.
 */
package io.atlasmap.itests.core;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import io.atlasmap.api.AtlasContext;
import io.atlasmap.api.AtlasSession;
import io.atlasmap.core.DefaultAtlasContextFactory;
import io.atlasmap.itests.core.TestHelper;
import java.net.URL;
import java.util.HashMap;
import org.junit.Assert;
import org.junit.Test;
import org.xmlunit.assertj.XmlAssert;

public class JsonXmlEnumTest {
    @Test
    public void test() throws Exception {
        URL url = Thread.currentThread().getContextClassLoader().getResource("mappings/atlasmapping-json-xml-enum.json");
        AtlasContext context = DefaultAtlasContextFactory.getInstance().createContext(url.toURI());
        this.assertForValues(context, "NA", "Available", "NA", "Available");
        this.assertForValues(context, "EMEA", "Pending", "EMEA", "Pending");
        this.assertForValues(context, "LATAM", "Sold", "LATAM", "Sold");
        this.assertForValues(context, "APAC", "Available", "NA", "Available");
    }

    private void assertForValues(AtlasContext context, String sourceJsonValue, String sourceXmlValue, String targetJsonValue, String targetXmlValue) throws Exception {
        AtlasSession session = context.createSession();
        String sourceJson = String.format("{\"region\": \"%s\"}", sourceJsonValue);
        session.setSourceDocument("address-enum-schema-19eabdd2-fec0-439a-824f-47f514a06177", (Object)sourceJson);
        String sourceXml = String.format("<tns:request xmlns:tns=\"http://syndesis.io/v1/swagger-connector-template/request\"><tns:body><Pet><status>%s</status></Pet></tns:body></tns:request>", sourceXmlValue);
        session.setSourceDocument("XMLSchemaSource-2c88ee00-7ddc-4137-b906-52d56e9b7f9e", (Object)sourceXml);
        context.process(session);
        Assert.assertFalse((String)TestHelper.printAudit(session), (boolean)session.hasErrors());
        String targetJson = (String)session.getTargetDocument("address-enum-schema-afdf5b0b-416a-4b7a-a4ba-f6219af64f43");
        JsonNode root = new ObjectMapper().readTree(targetJson);
        JsonNode field = root.get("region");
        Assert.assertFalse((boolean)field.isNull());
        Assert.assertTrue((boolean)field.isTextual());
        Assert.assertEquals((Object)targetJsonValue, (Object)field.asText());
        String targetXml = (String)session.getTargetDocument("XMLSchemaSource-c1b7b86e-959a-4cd8-b1fd-0bf52ddf0f43");
        Assert.assertNotNull((String)"target XML is null", (Object)targetXml);
        HashMap<String, String> namespaces = new HashMap<String, String>();
        namespaces.put("tns", "http://syndesis.io/v1/swagger-connector-template/request");
        XmlAssert.assertThat((Object)targetXml).withNamespaceContext(namespaces).valueByXPath("//tns:request/tns:body/Pet/status").isEqualTo((Object)targetXmlValue);
    }
}

