/*
 * Decompiled with CFR 0.152.
 */
package io.atlasmap.itests.core;

import io.atlasmap.api.AtlasContext;
import io.atlasmap.api.AtlasContextFactory;
import io.atlasmap.api.AtlasSession;
import io.atlasmap.core.ADMArchiveHandler;
import io.atlasmap.core.DefaultAtlasContextFactory;
import io.atlasmap.v2.AtlasMapping;
import io.atlasmap.v2.Collection;
import io.atlasmap.v2.Mapping;
import java.io.InputStream;
import java.util.Arrays;
import java.util.List;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.junit.Assert;
import org.junit.Test;

public class CsvMappingTest {
    public static final String MAPPINGS_JSON = "mappings/atlasmapping-csv.json";

    @Test
    public void testMapAllFields() throws Exception {
        AtlasContext context = this.createContext(MAPPINGS_JSON, "1", "2");
        AtlasSession session = context.createSession();
        session.setSourceDocument("source", (Object)"first_name,last_name\r\nBob,Johnson\r\nAndrew,Smith\r\n");
        context.process(session);
        Assert.assertFalse((boolean)session.hasErrors());
        Object csv = session.getTargetDocument("target-csv");
        Assert.assertThat((Object)csv, (Matcher)CoreMatchers.is((Object)"first,last\r\nBob,Johnson\r\nAndrew,Smith\r\n"));
    }

    @Test
    public void testMapOneOfTwoFields() throws Exception {
        AtlasContext context = this.createContext(MAPPINGS_JSON, "3");
        AtlasSession session = context.createSession();
        session.setSourceDocument("source", (Object)"first_name,last_name\r\nBob,Johnson\r\nAndrew,Smith\r\n");
        context.process(session);
        Assert.assertFalse((boolean)session.hasErrors());
        Object csv = session.getTargetDocument("target-csv");
        Assert.assertThat((Object)csv, (Matcher)CoreMatchers.is((Object)"last\r\nJohnson\r\nSmith\r\n"));
    }

    @Test
    public void testCapitalize() throws Exception {
        AtlasContext context = this.createContext(MAPPINGS_JSON, "4");
        AtlasSession session = context.createSession();
        session.setSourceDocument("source", (Object)"first_name,last_name\r\nbob,johnson\r\nandrew,smith\r\n");
        context.process(session);
        Assert.assertFalse((boolean)session.hasErrors());
        Object csv = session.getTargetDocument("target-csv");
        Assert.assertThat((Object)csv, (Matcher)CoreMatchers.is((Object)"first\r\nBob\r\nAndrew\r\n"));
    }

    @Test
    public void testCsvSourceAndTargetNotUsed() throws Exception {
        AtlasContext context = this.createContext("mappings/atlasmapping-csv-not-used.json", "1");
        AtlasSession session = context.createSession();
        session.setSourceDocument("csvSource", (Object)"first_name,last_name\r\nbob,johnson\r\nandrew,smith\r\n");
        session.setSourceDocument("jsonSource", (Object)"{\"first_name\":\"Tom\",\"last_name\":\"Silva\"}");
        context.process(session);
        Assert.assertFalse((boolean)session.hasErrors());
        Object json = session.getTargetDocument("jsonTarget");
        Object csv = session.getTargetDocument("csvTarget");
        Assert.assertThat((Object)csv, (Matcher)CoreMatchers.is((Object)""));
        Assert.assertThat((Object)json, (Matcher)CoreMatchers.is((Object)"{\"first_name\":\"Tom\"}"));
    }

    public AtlasContext createContext(String file, String ... mappingIds) throws Exception {
        InputStream in = Thread.currentThread().getContextClassLoader().getResourceAsStream(file);
        ADMArchiveHandler admHandler = new ADMArchiveHandler(Thread.currentThread().getContextClassLoader());
        admHandler.load(AtlasContextFactory.Format.JSON, in);
        AtlasMapping mapping = admHandler.getMappingDefinition();
        List<String> ids = Arrays.asList(mappingIds);
        mapping.getMappings().getMapping().removeIf(m -> {
            if (m instanceof Mapping) {
                return !ids.contains(((Mapping)m).getId());
            }
            if (m instanceof Collection) {
                Collection col = (Collection)m;
                col.getMappings().getMapping().removeIf(map -> !ids.contains(((Mapping)map).getId()));
                return col.getMappings().getMapping().isEmpty();
            }
            return false;
        });
        AtlasContext context = DefaultAtlasContextFactory.getInstance().createContext(mapping);
        return context;
    }
}

