/*
 * Decompiled with CFR 0.152.
 */
package io.atlasmap.itests.core.issue;

import io.atlasmap.api.AtlasContext;
import io.atlasmap.api.AtlasSession;
import io.atlasmap.core.DefaultAtlasContextFactory;
import io.atlasmap.itests.core.TestHelper;
import io.atlasmap.itests.core.issue.TargetClass;
import java.net.URL;
import org.junit.Assert;
import org.junit.Test;

public class ConstantPropertyTest {
    @Test
    public void test() throws Exception {
        URL url = Thread.currentThread().getContextClassLoader().getResource("mappings/issue/constant-property-mapping.json");
        AtlasContext context = DefaultAtlasContextFactory.getInstance().createContext(url.toURI());
        AtlasSession session = context.createSession();
        context.process(session);
        Assert.assertFalse((String)TestHelper.printAudit(session), (boolean)session.hasErrors());
        TargetClass output = (TargetClass)TargetClass.class.cast(session.getTargetDocument("io.atlasmap.itests.core.issue.TargetClass"));
        Assert.assertEquals((Object)"testValue", (Object)output.getTargetName());
        Assert.assertNotEquals((Object)"testPath", (Object)output.getTargetFirstName());
        Assert.assertEquals((long)777L, (long)output.getTargetInteger());
        System.setProperty("testProp", "testProp-sysProp");
        System.setProperty("PATH", "PATH-sysProp");
        context.process(session);
        Assert.assertFalse((String)TestHelper.printAudit(session), (boolean)session.hasErrors());
        output = (TargetClass)TargetClass.class.cast(session.getTargetDocument("io.atlasmap.itests.core.issue.TargetClass"));
        Assert.assertEquals((Object)"testProp-sysProp", (Object)output.getTargetName());
        Assert.assertEquals((Object)"PATH-sysProp", (Object)output.getTargetFirstName());
        Assert.assertEquals((long)777L, (long)output.getTargetInteger());
        session.getProperties().put("testProp", "testProp-runtimeProp");
        session.getProperties().put("PATH", "PATH-runtimeProp");
        context.process(session);
        Assert.assertFalse((String)TestHelper.printAudit(session), (boolean)session.hasErrors());
        output = (TargetClass)TargetClass.class.cast(session.getTargetDocument("io.atlasmap.itests.core.issue.TargetClass"));
        Assert.assertEquals((Object)"testProp-runtimeProp", (Object)output.getTargetName());
        Assert.assertEquals((Object)"PATH-runtimeProp", (Object)output.getTargetFirstName());
        Assert.assertEquals((long)777L, (long)output.getTargetInteger());
    }
}

