/*
 * Decompiled with CFR 0.152.
 */
package io.atlasmap.itests.core.issue;

import io.atlasmap.api.AtlasContext;
import io.atlasmap.api.AtlasSession;
import io.atlasmap.core.AtlasMappingService;
import io.atlasmap.core.DefaultAtlasContextFactory;
import io.atlasmap.itests.core.TestHelper;
import io.atlasmap.itests.core.issue.SourceClass;
import io.atlasmap.itests.core.issue.TargetClass;
import io.atlasmap.v2.AtlasMapping;
import java.net.URL;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class PrependAppendTest {
    private AtlasMappingService mappingService;

    @Before
    public void before() {
        this.mappingService = DefaultAtlasContextFactory.getInstance().getMappingService();
    }

    @Test
    public void test() throws Exception {
        URL url = Thread.currentThread().getContextClassLoader().getResource("mappings/issue/prepend-append-mapping.json");
        AtlasMapping mapping = this.mappingService.loadMapping(url);
        AtlasContext context = DefaultAtlasContextFactory.getInstance().createContext(mapping);
        AtlasSession session = context.createSession();
        session.setSourceDocument("io.atlasmap.itests.core.issue.SourceClass", (Object)new SourceClass().setSourceString("foo"));
        context.process(session);
        Assert.assertFalse((String)TestHelper.printAudit(session), (boolean)session.hasErrors());
        Object output = session.getTargetDocument("io.atlasmap.itests.core.issue.TargetClass");
        Assert.assertEquals(TargetClass.class, output.getClass());
        Assert.assertEquals((Object)"prepend-foo-append", (Object)((TargetClass)output).getTargetString());
    }
}

