/*
 * Decompiled with CFR 0.152.
 */
package io.atlasmap.itests.core;

import io.atlasmap.api.AtlasContext;
import io.atlasmap.api.AtlasSession;
import io.atlasmap.core.AtlasMappingService;
import io.atlasmap.core.DefaultAtlasContextFactory;
import io.atlasmap.itests.core.TestHelper;
import io.atlasmap.itests.core.issue.Item;
import io.atlasmap.itests.core.issue.SourceClass;
import io.atlasmap.itests.core.issue.TargetClass;
import io.atlasmap.java.test.SourceFlatPrimitiveClass;
import io.atlasmap.java.test.TargetFlatPrimitiveClass;
import io.atlasmap.java.test.TargetTestClass;
import io.atlasmap.v2.AtlasMapping;
import io.atlasmap.v2.Audit;
import io.atlasmap.v2.AuditStatus;
import java.net.URL;
import java.nio.file.Files;
import java.nio.file.Paths;
import java.util.Arrays;
import java.util.Date;
import java.util.List;
import org.hamcrest.CoreMatchers;
import org.hamcrest.FeatureMatcher;
import org.hamcrest.Matcher;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class MultiplicityTransformationTest {
    private AtlasMappingService mappingService;

    @Before
    public void before() {
        this.mappingService = DefaultAtlasContextFactory.getInstance().getMappingService();
    }

    @Test
    public void testConcatenateSplit() throws Exception {
        URL url = Thread.currentThread().getContextClassLoader().getResource("mappings/atlasmapping-multiplicity-transformation-concatenate-split.json");
        AtlasMapping mapping = this.mappingService.loadMapping(url);
        AtlasContext context = DefaultAtlasContextFactory.getInstance().createContext(mapping);
        AtlasSession session = context.createSession();
        SourceClass source = new SourceClass().setSourceFirstName("Manjiro").setSourceLastName("Nakahama").setSourceName("Manjiro,Nakahama").setSourceString("one,two,three").setSourceStringList(Arrays.asList("one", "two", "three")).setSourceHiphenatedInteger("1-20-300-4000").setSourceStreet("314 Littleton Rd").setSourceWeight("128.965 kg");
        session.setSourceDocument("io.atlasmap.itests.core.issue.SourceClass", (Object)source);
        context.process(session);
        Assert.assertFalse((String)TestHelper.printAudit(session), (boolean)session.hasErrors());
        Assert.assertTrue((String)"split(STRING) => INTEGER/DOUBLE mapping should get warnings", (boolean)session.hasWarns());
        Assert.assertEquals((long)9L, (long)session.getAudits().getAudit().stream().filter(a -> a.getStatus() == AuditStatus.WARN).count());
        Object output = session.getTargetDocument("io.atlasmap.itests.core.issue.TargetClass");
        Assert.assertEquals(TargetClass.class, output.getClass());
        TargetClass target = (TargetClass)TargetClass.class.cast(output);
        Assert.assertEquals((Object)"Manjiro", (Object)target.getTargetFirstName());
        Assert.assertEquals((Object)"Nakahama", (Object)target.getTargetLastName());
        Assert.assertEquals((Object)"Manjiro,Nakahama", (Object)target.getTargetName());
        Assert.assertEquals((Object)"One,Nakahama", (Object)target.getTargetFullName());
        Assert.assertThat((Object)session.getAudits().getAudit(), (Matcher)CoreMatchers.hasItem((Matcher)new FeatureMatcher<Audit, String>(CoreMatchers.is((Object)"Using only the first element of the collection since a single value is expected in a multi-field selection."), "message", "message"){

            protected String featureValueOf(Audit actual) {
                return actual.getMessage();
            }
        }));
        Assert.assertEquals((Object)"one,two,three", (Object)target.getTargetString());
        Assert.assertEquals((Object)new Integer(314), (Object)target.getTargetStreetNumber());
        Assert.assertEquals((Object)"Littleton", (Object)target.getTargetStreetName1());
        Assert.assertEquals((Object)"Rd", (Object)target.getTargetStreetName2());
        List<String> list = target.getTargetStringList();
        Assert.assertEquals((long)3L, (long)list.size());
        Assert.assertEquals((Object)"one", (Object)list.get(0));
        Assert.assertEquals((Object)"two", (Object)list.get(1));
        Assert.assertEquals((Object)"three", (Object)list.get(2));
        List<Integer> intList = target.getTargetIntegerList();
        Assert.assertEquals((long)4L, (long)intList.size());
        Assert.assertEquals((Object)new Integer(1), (Object)intList.get(0));
        Assert.assertEquals((Object)new Integer(20), (Object)intList.get(1));
        Assert.assertEquals((Object)new Integer(300), (Object)intList.get(2));
        Assert.assertEquals((Object)new Integer(4000), (Object)intList.get(3));
        Assert.assertEquals((Object)128.965, (Object)target.getTargetWeightDouble());
        Assert.assertEquals((Object)"kg", (Object)target.getTargetWeightUnit());
    }

    @Test
    public void testConcatenateTypes() throws Exception {
        URL url = Thread.currentThread().getContextClassLoader().getResource("mappings/atlasmapping-multiplicity-transformation-concatenate-types.json");
        AtlasMapping mapping = this.mappingService.loadMapping(url);
        AtlasContext context = DefaultAtlasContextFactory.getInstance().createContext(mapping);
        AtlasSession session = context.createSession();
        TargetTestClass source = new TargetTestClass();
        source.setCreated(new Date());
        TargetFlatPrimitiveClass primitives = new TargetFlatPrimitiveClass();
        primitives.setBoxedStringField("boxedString");
        primitives.setCharField('c');
        primitives.setIntField(1);
        primitives.setFloatField(1.3f);
        primitives.setLongField(2L);
        primitives.setShortField((short)2);
        primitives.setDoubleField(3.1);
        primitives.setBoxedCharField(new Character('c'));
        primitives.setBoxedIntField(new Integer(1));
        primitives.setBoxedFloatField(new Float(1.3f));
        primitives.setBoxedLongField(new Long(2L));
        primitives.setBoxedShortField(new Short(2));
        primitives.setBoxedDoubleField(new Double(3.1));
        source.setPrimitives(primitives);
        session.setSourceDocument("io.atlasmap.java.test.TargetTestClass", (Object)source);
        context.process(session);
        Assert.assertFalse((String)TestHelper.printAudit(session), (boolean)session.hasErrors());
        Object output = session.getTargetDocument("io.atlasmap.java.test.TargetTestClass");
        Assert.assertEquals(TargetTestClass.class, output.getClass());
        TargetTestClass target = (TargetTestClass)TargetTestClass.class.cast(output);
        Assert.assertEquals((String)("[" + target.getFullAddress() + "]"), (long)14L, (long)target.getFullAddress().split(" ").length);
    }

    @Test
    public void testItemAt() throws Exception {
        URL url = Thread.currentThread().getContextClassLoader().getResource("mappings/atlasmapping-multiplicity-transformation-itemAt.json");
        AtlasMapping mapping = this.mappingService.loadMapping(url);
        AtlasContext context = DefaultAtlasContextFactory.getInstance().createContext(mapping);
        AtlasSession session = context.createSession();
        SourceClass source = new SourceClass().setSourceStringList(Arrays.asList("one", "two", "three"));
        session.setSourceDocument("io.atlasmap.itests.core.issue.SourceClass", (Object)source);
        context.process(session);
        Assert.assertFalse((String)TestHelper.printAudit(session), (boolean)session.hasErrors());
        Assert.assertFalse((String)TestHelper.printAudit(session), (boolean)session.hasWarns());
        Object output = session.getTargetDocument("io.atlasmap.itests.core.issue.TargetClass");
        Assert.assertEquals(TargetClass.class, output.getClass());
        TargetClass target = (TargetClass)TargetClass.class.cast(output);
        Assert.assertEquals((Object)"two", (Object)target.getTargetString());
    }

    @Test
    public void testExpression() throws Exception {
        URL url = Thread.currentThread().getContextClassLoader().getResource("mappings/atlasmapping-multiplicity-transformation-expression.json");
        AtlasMapping mapping = this.mappingService.loadMapping(url);
        AtlasContext context = DefaultAtlasContextFactory.getInstance().createContext(mapping);
        AtlasSession session = context.createSession();
        SourceClass source = new SourceClass().setSourceString("").setSourceInteger(123).setSourceFirstName(null).setSourceLastName("").setSourceInteger2(-123);
        session.setSourceDocument("io.atlasmap.itests.core.issue.SourceClass", (Object)source);
        context.process(session);
        Assert.assertFalse((String)TestHelper.printAudit(session), (boolean)session.hasErrors());
        Assert.assertFalse((String)TestHelper.printAudit(session), (boolean)session.hasWarns());
        Object output = session.getTargetDocument("io.atlasmap.itests.core.issue.TargetClass");
        Assert.assertEquals(TargetClass.class, output.getClass());
        TargetClass target = (TargetClass)TargetClass.class.cast(output);
        Assert.assertEquals((Object)"one-two-three", (Object)target.getTargetString());
        Assert.assertEquals((long)123L, (long)target.getTargetInteger());
        Assert.assertEquals((Object)"last name is empty", (Object)target.getTargetName());
        Assert.assertEquals((Object)"true", (Object)target.getTargetFirstName());
        session = context.createSession();
        source = new SourceClass().setSourceString("not empty").setSourceInteger(789).setSourceFirstName(null).setSourceLastName("lastname").setSourceInteger2(790);
        session.setSourceDocument("io.atlasmap.itests.core.issue.SourceClass", (Object)source);
        context.process(session);
        Assert.assertFalse((String)TestHelper.printAudit(session), (boolean)session.hasErrors());
        Assert.assertFalse((String)TestHelper.printAudit(session), (boolean)session.hasWarns());
        output = session.getTargetDocument("io.atlasmap.itests.core.issue.TargetClass");
        Assert.assertEquals(TargetClass.class, output.getClass());
        target = (TargetClass)TargetClass.class.cast(output);
        Assert.assertEquals((Object)"not one-two-three", (Object)target.getTargetString());
        Assert.assertEquals((long)456L, (long)target.getTargetInteger());
        Assert.assertEquals((Object)"last name is not empty", (Object)target.getTargetName());
        Assert.assertEquals((Object)"false", (Object)target.getTargetFirstName());
    }

    @Test
    public void testCapitalizeExpressionWithCollection() throws Exception {
        URL url = Thread.currentThread().getContextClassLoader().getResource("mappings/atlasmapping-multiplicity-transformation-capitalize-expression.json");
        AtlasMapping mapping = this.mappingService.loadMapping(url);
        AtlasContext context = DefaultAtlasContextFactory.getInstance().createContext(mapping);
        AtlasSession session = context.createSession();
        SourceClass source = new SourceClass().setSourceStringList(Arrays.asList("bob", "john", "andrea"));
        session.setSourceDocument("io.atlasmap.itests.core.issue.SourceClass", (Object)source);
        context.process(session);
        Assert.assertFalse((String)TestHelper.printAudit(session), (boolean)session.hasErrors());
        Assert.assertFalse((String)TestHelper.printAudit(session), (boolean)session.hasWarns());
        Object output = session.getTargetDocument("io.atlasmap.itests.core.issue.TargetClass");
        Assert.assertEquals(TargetClass.class, output.getClass());
        TargetClass target = (TargetClass)TargetClass.class.cast(output);
        Assert.assertEquals(Arrays.asList("Bob", "John", "Andrea"), target.getTargetStringList());
    }

    @Test
    public void testConcatenateExpressionWithCollection() throws Exception {
        URL url = Thread.currentThread().getContextClassLoader().getResource("mappings/atlasmapping-multiplicity-transformation-concatenate-expression.json");
        AtlasMapping mapping = this.mappingService.loadMapping(url);
        AtlasContext context = DefaultAtlasContextFactory.getInstance().createContext(mapping);
        AtlasSession session = context.createSession();
        SourceClass source = new SourceClass().setSourceStringList(Arrays.asList("bob", "john", "andrea"));
        source.setSourceString(",");
        session.setSourceDocument("io.atlasmap.itests.core.issue.SourceClass", (Object)source);
        context.process(session);
        Assert.assertFalse((String)TestHelper.printAudit(session), (boolean)session.hasErrors());
        Assert.assertFalse((String)TestHelper.printAudit(session), (boolean)session.hasWarns());
        Object output = session.getTargetDocument("io.atlasmap.itests.core.issue.TargetClass");
        Assert.assertEquals(TargetClass.class, output.getClass());
        TargetClass target = (TargetClass)TargetClass.class.cast(output);
        Assert.assertEquals((Object)"Bob,John,Andrea", (Object)target.getTargetString());
    }

    @Test
    public void testConcatenateExpressionWithTwoCollections() throws Exception {
        URL url = Thread.currentThread().getContextClassLoader().getResource("mappings/atlasmapping-multiplicity-transformation-concatenate-expression.json");
        AtlasMapping mapping = this.mappingService.loadMapping(url);
        AtlasContext context = DefaultAtlasContextFactory.getInstance().createContext(mapping);
        AtlasSession session = context.createSession();
        SourceClass source = new SourceClass().setSourceStringList(Arrays.asList("bob", "john", "andrea"));
        source.setSourceList(Arrays.asList(new Item("thomas", null), new Item("arnold", null)));
        source.setSourceString(",");
        session.setSourceDocument("io.atlasmap.itests.core.issue.SourceClass", (Object)source);
        context.process(session);
        Assert.assertFalse((String)TestHelper.printAudit(session), (boolean)session.hasErrors());
        Assert.assertFalse((String)TestHelper.printAudit(session), (boolean)session.hasWarns());
        Object output = session.getTargetDocument("io.atlasmap.itests.core.issue.TargetClass");
        Assert.assertEquals(TargetClass.class, output.getClass());
        TargetClass target = (TargetClass)TargetClass.class.cast(output);
        Assert.assertEquals((Object)"bob,john,andrea,thomas,arnold", (Object)target.getTargetFirstName());
    }

    @Test
    public void testAdd() throws Exception {
        URL url = Thread.currentThread().getContextClassLoader().getResource("mappings/atlasmapping-multiplicity-transformation-add.json");
        AtlasMapping mapping = this.mappingService.loadMapping(url);
        AtlasContext context = DefaultAtlasContextFactory.getInstance().createContext(mapping);
        AtlasSession session = context.createSession();
        String sourceJson = new String(Files.readAllBytes(Paths.get(Thread.currentThread().getContextClassLoader().getResource("data/json-source.json").toURI())));
        session.setSourceDocument("json-source", (Object)sourceJson);
        String sourceXml = new String(Files.readAllBytes(Paths.get(Thread.currentThread().getContextClassLoader().getResource("data/xml-source.xml").toURI())));
        session.setSourceDocument("xml-source", (Object)sourceXml);
        SourceFlatPrimitiveClass sourceJava = new SourceFlatPrimitiveClass();
        sourceJava.setIntArrayField(new int[]{1, 3, 5, 7});
        sourceJava.setBoxedIntListField(Arrays.asList(2, 4, 6, 8));
        session.setSourceDocument("java-source", (Object)sourceJava);
        context.process(session);
        Assert.assertFalse((String)TestHelper.printAudit(session), (boolean)session.hasErrors());
        Object output = session.getTargetDocument("io.atlasmap.java.test.TargetFlatPrimitiveClass");
        Assert.assertEquals(TargetFlatPrimitiveClass.class, output.getClass());
        TargetFlatPrimitiveClass target = (TargetFlatPrimitiveClass)TargetFlatPrimitiveClass.class.cast(output);
        Assert.assertEquals((double)new Float(16.0f).floatValue(), (double)target.getFloatField(), (double)1.0E-15);
        Assert.assertEquals((double)new Double(16.0), (double)target.getDoubleField(), (double)1.0E-15);
        Assert.assertEquals((long)16L, (long)target.getLongField());
        Assert.assertEquals((long)20L, (long)target.getIntField());
    }
}

