/*
 * Decompiled with CFR 0.152.
 */
package io.atlasmap.itests.core;

import io.atlasmap.api.AtlasContext;
import io.atlasmap.api.AtlasSession;
import io.atlasmap.core.AtlasMappingService;
import io.atlasmap.core.DefaultAtlasContextFactory;
import io.atlasmap.itests.core.TestHelper;
import io.atlasmap.java.test.TargetContact;
import io.atlasmap.java.test.TargetTestClass;
import io.atlasmap.v2.AtlasMapping;
import java.io.BufferedReader;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.URL;
import java.util.LinkedList;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class DfdlCsvTest {
    private AtlasMappingService mappingService;

    @Before
    public void before() {
        this.mappingService = DefaultAtlasContextFactory.getInstance().getMappingService();
    }

    @Test
    public void test() throws Exception {
        URL url = Thread.currentThread().getContextClassLoader().getResource("mappings/atlasmapping-dfdl-csv.json");
        AtlasMapping mapping = this.mappingService.loadMapping(url);
        AtlasContext context = DefaultAtlasContextFactory.getInstance().createContext(mapping);
        AtlasSession session = context.createSession();
        TargetTestClass javaSource = new TargetTestClass();
        javaSource.setContactList(new LinkedList());
        TargetContact tc = new TargetContact();
        tc.setFirstName("firstName1");
        tc.setLastName("lastName1");
        tc.setPhoneNumber("111-111-1111");
        javaSource.getContactList().add(tc);
        tc = new TargetContact();
        tc.setFirstName("firstName2");
        tc.setLastName("lastName2");
        tc.setPhoneNumber("222-222-2222");
        javaSource.getContactList().add(tc);
        tc = new TargetContact();
        tc.setFirstName("firstName3");
        tc.setLastName("lastName3");
        tc.setPhoneNumber("333-333-3333");
        javaSource.getContactList().add(tc);
        session.setSourceDocument("java-source", (Object)javaSource);
        String csvSource = this.readStringFromFile("atlas-dfdl-csv-simple.csv");
        session.setSourceDocument("dfdl-csv-source", (Object)csvSource);
        context.process(session);
        Assert.assertFalse((String)TestHelper.printAudit(session), (boolean)session.hasErrors());
        Assert.assertTrue((String)TestHelper.printAudit(session), (boolean)session.hasWarns());
        Object jt = session.getTargetDocument("java-target");
        Assert.assertEquals(TargetTestClass.class, jt.getClass());
        TargetTestClass javaTarget = (TargetTestClass)TargetTestClass.class.cast(jt);
        Assert.assertEquals((long)3L, (long)javaTarget.getContactList().size());
        Assert.assertEquals((Object)"l1r1", (Object)((TargetContact)javaTarget.getContactList().get(0)).getFirstName());
        Assert.assertEquals((Object)"l3r3", (Object)((TargetContact)javaTarget.getContactList().get(2)).getPhoneNumber());
        Object dct = session.getTargetDocument("dfdl-csv-target");
        String dfdlCsvTarget = (String)String.class.cast(dct);
        Assert.assertEquals((Object)this.readStringFromFile("data/dfdl-csv-target.csv"), (Object)dfdlCsvTarget);
    }

    private String readStringFromFile(String name) throws Exception {
        String line;
        InputStream in = Thread.currentThread().getContextClassLoader().getResourceAsStream(name);
        BufferedReader r = new BufferedReader(new InputStreamReader(in));
        StringBuilder buf = new StringBuilder();
        while ((line = r.readLine()) != null) {
            buf.append(line).append('\n');
        }
        return buf.toString();
    }
}

