/*
 * Decompiled with CFR 0.152.
 */
package io.atlasmap.itests.core.issue;

import io.atlasmap.api.AtlasContext;
import io.atlasmap.api.AtlasSession;
import io.atlasmap.core.AtlasMappingService;
import io.atlasmap.core.DefaultAtlasContextFactory;
import io.atlasmap.itests.core.TestHelper;
import io.atlasmap.itests.core.issue.Item;
import io.atlasmap.itests.core.issue.SourceClass;
import io.atlasmap.itests.core.issue.TargetClass;
import io.atlasmap.v2.AtlasMapping;
import java.net.URL;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class CollectionComplexTest {
    private AtlasMappingService mappingService;

    @Before
    public void before() {
        this.mappingService = DefaultAtlasContextFactory.getInstance().getMappingService();
    }

    @Test
    public void test() throws Exception {
        URL url = Thread.currentThread().getContextClassLoader().getResource("mappings/issue/collection-complex-mapping.json");
        AtlasMapping mapping = this.mappingService.loadMapping(url);
        AtlasContext context = DefaultAtlasContextFactory.getInstance().createContext(mapping);
        AtlasSession session = context.createSession();
        SourceClass sourceClass = new SourceClass().setSourceName("javaSourceName");
        sourceClass.getSourceList().add(new Item().setName("java1"));
        sourceClass.getSourceList().add(new Item().setName("java2"));
        sourceClass.getSourceList().add(new Item().setName("java3"));
        session.setSourceDocument("SourceClass", (Object)sourceClass);
        session.setSourceDocument("SourceJson", (Object)"{\"sourceList\":[\"json1\", \"json2\", \"json3\"]}");
        session.setSourceDocument("SourceXml", (Object)"<root><sourceList><name>xml1</name></sourceList><sourceList><name>xml2</name></sourceList><sourceList><name>xml3</name></sourceList></root>");
        context.process(session);
        Assert.assertFalse((String)TestHelper.printAudit(session), (boolean)session.hasErrors());
        Object targetJava = session.getTargetDocument("TargetClass");
        Assert.assertEquals(TargetClass.class, targetJava.getClass());
        TargetClass targetClass = (TargetClass)targetJava;
        Assert.assertEquals((Object)"xml3", (Object)targetClass.getTargetName());
        Assert.assertEquals((long)3L, (long)targetClass.getTargetList().size());
        Assert.assertEquals((Object)"json1", (Object)targetClass.getTargetList().get(0).getName());
        Assert.assertEquals((Object)"json2", (Object)targetClass.getTargetList().get(1).getName());
        Assert.assertEquals((Object)"json3", (Object)targetClass.getTargetList().get(2).getName());
        Object targetJson = session.getTargetDocument("TargetJson");
        Assert.assertEquals((Object)"{\"javaList\":[{\"name\":\"java1\"},{\"name\":\"java2\"},{\"name\":\"java3\"}],\"xmlList\":[\"xml1\",\"xml2\",\"xml3\"]}", (Object)targetJson);
        Object targetXml = session.getTargetDocument("TargetXml");
        Assert.assertEquals((Object)"<?xml version=\"1.0\" encoding=\"UTF-8\" standalone=\"no\"?><root><javaList><name>java1</name></javaList><javaList><name>java2</name></javaList><javaList><name>java3</name></javaList><jsonList><name>json1</name></jsonList><jsonList><name>json2</name></jsonList><jsonList><name>json3</name></jsonList></root>", (Object)targetXml);
    }
}

