/*
 * Decompiled with CFR 0.152.
 */
package io.atlasmap.itests.core;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.SerializationFeature;
import com.fasterxml.jackson.databind.node.ArrayNode;
import io.atlasmap.api.AtlasContext;
import io.atlasmap.api.AtlasException;
import io.atlasmap.api.AtlasSession;
import io.atlasmap.core.AtlasMappingService;
import io.atlasmap.core.DefaultAtlasContextFactory;
import io.atlasmap.itests.core.TestHelper;
import io.atlasmap.v2.AtlasMapping;
import io.atlasmap.v2.Audit;
import io.atlasmap.v2.AuditStatus;
import io.atlasmap.v2.Mapping;
import java.io.IOException;
import java.net.URISyntaxException;
import java.net.URL;
import java.nio.file.Files;
import java.nio.file.Paths;
import java.util.Arrays;
import java.util.List;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class NestedCollectionJsonTest {
    private static final Logger LOG = LoggerFactory.getLogger(NestedCollectionJsonTest.class);
    private AtlasMappingService mappingService;
    private ObjectMapper mapper;

    @Before
    public void before() {
        this.mappingService = DefaultAtlasContextFactory.getInstance().getMappingService();
        this.mapper = new ObjectMapper().enable(SerializationFeature.INDENT_OUTPUT).configure(DeserializationFeature.ACCEPT_SINGLE_VALUE_AS_ARRAY, true).setSerializationInclusion(JsonInclude.Include.NON_NULL);
    }

    @Test
    public void testAsymmetricSingleTarget() throws Exception {
        URL url = Thread.currentThread().getContextClassLoader().getResource("mappings/atlasmapping-nested-collection-asymmetric.json");
        AtlasMapping mapping = this.mappingService.loadMapping(url);
        mapping.getMappings().getMapping().removeIf(m -> !"3-1".equals(((Mapping)m).getId()));
        AtlasContext context = DefaultAtlasContextFactory.getInstance().createContext(mapping);
        AtlasSession session = context.createSession();
        String source = new String(Files.readAllBytes(Paths.get(Thread.currentThread().getContextClassLoader().getResource("mappings/document-nested-collection.json").toURI())));
        session.setSourceDocument("JSONInstanceNestedCollection", (Object)source);
        context.process(session);
        Assert.assertFalse((String)TestHelper.printAudit(session), (boolean)session.hasErrors());
        Assert.assertFalse((String)TestHelper.printAudit(session), (boolean)session.hasWarns());
        Object output = session.getTargetDocument("JSONInstanceNestedCollection");
        Assert.assertEquals(String.class, output.getClass());
        JsonNode outputJson = this.mapper.readTree((String)output);
        String prettyPrinted = this.mapper.writeValueAsString((Object)outputJson);
        ArrayNode firstArray = (ArrayNode)outputJson.get("firstArray");
        Assert.assertEquals((String)prettyPrinted, (long)10L, (long)firstArray.size());
        Assert.assertEquals((String)prettyPrinted, (Object)"thirdArrayValue0-0-0", (Object)firstArray.get(0).get("value").asText());
        Assert.assertNull((String)prettyPrinted, (Object)firstArray.get(0).get("secondArray"));
        Assert.assertEquals((String)prettyPrinted, (Object)"thirdArrayValue0-0-1", (Object)firstArray.get(1).get("value").asText());
        Assert.assertNull((String)prettyPrinted, (Object)firstArray.get(1).get("secondArray"));
        Assert.assertEquals((String)prettyPrinted, (Object)"thirdArrayValue0-1-0", (Object)firstArray.get(2).get("value").asText());
        Assert.assertNull((String)prettyPrinted, (Object)firstArray.get(2).get("secondArray"));
        Assert.assertEquals((String)prettyPrinted, (Object)"thirdArrayValue0-1-1", (Object)firstArray.get(3).get("value").asText());
        Assert.assertNull((String)prettyPrinted, (Object)firstArray.get(3).get("secondArray"));
        Assert.assertEquals((String)prettyPrinted, (Object)"thirdArrayValue0-1-2", (Object)firstArray.get(4).get("value").asText());
        Assert.assertNull((String)prettyPrinted, (Object)firstArray.get(4).get("secondArray"));
        Assert.assertEquals((String)prettyPrinted, (Object)"thirdArrayValue1-0-0", (Object)firstArray.get(5).get("value").asText());
        Assert.assertNull((String)prettyPrinted, (Object)firstArray.get(5).get("secondArray"));
        Assert.assertEquals((String)prettyPrinted, (Object)"thirdArrayValue1-0-1", (Object)firstArray.get(6).get("value").asText());
        Assert.assertNull((String)prettyPrinted, (Object)firstArray.get(6).get("secondArray"));
        Assert.assertEquals((String)prettyPrinted, (Object)"thirdArrayValue1-0-2", (Object)firstArray.get(7).get("value").asText());
        Assert.assertNull((String)prettyPrinted, (Object)firstArray.get(7).get("secondArray"));
        Assert.assertEquals((String)prettyPrinted, (Object)"thirdArrayValue1-1-0", (Object)firstArray.get(8).get("value").asText());
        Assert.assertNull((String)prettyPrinted, (Object)firstArray.get(8).get("secondArray"));
        Assert.assertEquals((String)prettyPrinted, (Object)"thirdArrayValue1-1-1", (Object)firstArray.get(9).get("value").asText());
        Assert.assertNull((String)prettyPrinted, (Object)firstArray.get(9).get("secondArray"));
    }

    @Test
    public void testSamePaths1stLevelCollection() throws Exception {
        JsonNode outputJson = this.processJsonNestedCollection(Arrays.asList("1-1"));
        String prettyPrinted = this.mapper.writeValueAsString((Object)outputJson);
        ArrayNode firstArray = this.assert1stLevelCollection(outputJson, prettyPrinted);
        Assert.assertNull((String)prettyPrinted, (Object)firstArray.get(0).get("secondArray"));
        Assert.assertNull((String)prettyPrinted, (Object)firstArray.get(1).get("secondArray"));
    }

    @Test
    public void testSamePaths1stAnd2ndLevelNestedCollection() throws Exception {
        JsonNode outputJson = this.processJsonNestedCollection(Arrays.asList("1-1", "2-2"));
        String prettyPrinted = this.mapper.writeValueAsString((Object)outputJson);
        this.assert1stLevelCollection(outputJson, prettyPrinted);
        this.assert2ndLevelNestedCollection(outputJson, prettyPrinted);
    }

    @Test
    public void testSamePaths2ndLevelNestedCollection() throws Exception {
        JsonNode outputJson = this.processJsonNestedCollection(Arrays.asList("2-2"));
        String prettyPrinted = this.mapper.writeValueAsString((Object)outputJson);
        this.assert2ndLevelNestedCollection(outputJson, prettyPrinted);
    }

    @Test
    public void testSamePaths1stAnd2ndAnd3rdLevelNestedCollection() throws Exception {
        JsonNode outputJson = this.processJsonNestedCollection(Arrays.asList("1-1", "2-2", "3-3"));
        String prettyPrinted = this.mapper.writeValueAsString((Object)outputJson);
        this.assert1stLevelCollection(outputJson, prettyPrinted);
        this.assert2ndLevelNestedCollection(outputJson, prettyPrinted);
        this.assert3rdLevelNestedCollection(outputJson, prettyPrinted);
    }

    @Test
    public void testSamePaths2ndAnd3rdLevelNestedCollection() throws Exception {
        JsonNode outputJson = this.processJsonNestedCollection(Arrays.asList("2-2", "3-3"));
        String prettyPrinted = this.mapper.writeValueAsString((Object)outputJson);
        this.assert2ndLevelNestedCollection(outputJson, prettyPrinted);
        this.assert3rdLevelNestedCollection(outputJson, prettyPrinted);
    }

    @Test
    public void testSamePaths1stAnd3rdLevelNestedCollection() throws Exception {
        JsonNode outputJson = this.processJsonNestedCollection(Arrays.asList("1-1", "3-3"));
        String prettyPrinted = this.mapper.writeValueAsString((Object)outputJson);
        this.assert1stLevelCollection(outputJson, prettyPrinted);
        this.assert3rdLevelNestedCollection(outputJson, prettyPrinted);
    }

    @Test
    public void testSamePaths3rdLevelNestedCollection() throws Exception {
        JsonNode outputJson = this.processJsonNestedCollection(Arrays.asList("3-3"));
        String prettyPrinted = this.mapper.writeValueAsString((Object)outputJson);
        this.assert3rdLevelNestedCollection(outputJson, prettyPrinted);
    }

    @Test
    public void testRenamedPaths3rdLevelNestedCollection() throws Exception {
        JsonNode outputJson = this.processJsonNestedCollection(Arrays.asList("3-3renamed"));
        String prettyPrinted = this.mapper.writeValueAsString((Object)outputJson);
        this.assert3rdLevelNestedCollection(outputJson, prettyPrinted, "Renamed");
    }

    @Test
    public void testSamePaths1stAndRenamedPaths3rdLevelNestedCollection() throws Exception {
        JsonNode outputJson = this.processJsonNestedCollection(Arrays.asList("1-1", "3-3renamed"));
        String prettyPrinted = this.mapper.writeValueAsString((Object)outputJson);
        this.assert1stLevelCollection(outputJson, prettyPrinted);
        this.assert3rdLevelNestedCollection(outputJson, prettyPrinted, "Renamed");
    }

    @Test
    public void testSamePaths1stAnd2nAndRenamedPaths3rdLevelNestedCollection() throws Exception {
        JsonNode outputJson = this.processJsonNestedCollection(Arrays.asList("1-1", "2-2", "3-3renamed"));
        String prettyPrinted = this.mapper.writeValueAsString((Object)outputJson);
        this.assert1stLevelCollection(outputJson, prettyPrinted);
        this.assert2ndLevelNestedCollection(outputJson, prettyPrinted);
        this.assert3rdLevelNestedCollection(outputJson, prettyPrinted, "Renamed");
    }

    @Test
    public void testSamePaths1stAnd2ndAnd3rdAndRenamedPaths3rdLevelNestedCollection() throws Exception {
        JsonNode outputJson = this.processJsonNestedCollection(Arrays.asList("1-1", "2-2", "3-3", "3-3renamed"));
        String prettyPrinted = this.mapper.writeValueAsString((Object)outputJson);
        this.assert1stLevelCollection(outputJson, prettyPrinted);
        this.assert2ndLevelNestedCollection(outputJson, prettyPrinted);
        this.assert3rdLevelNestedCollection(outputJson, prettyPrinted);
        this.assert3rdLevelNestedCollection(outputJson, prettyPrinted, "Renamed");
    }

    private JsonNode processJsonNestedCollection(List<String> mappingsToProcess) throws AtlasException, IOException, URISyntaxException {
        URL url = Thread.currentThread().getContextClassLoader().getResource("mappings/atlasmapping-nested-collection-symmetric.json");
        AtlasMapping mapping = this.mappingService.loadMapping(url);
        mapping.getMappings().getMapping().removeIf(m -> !mappingsToProcess.contains(((Mapping)m).getId()));
        AtlasContext context = DefaultAtlasContextFactory.getInstance().createContext(mapping);
        AtlasSession session = context.createSession();
        String source = new String(Files.readAllBytes(Paths.get(Thread.currentThread().getContextClassLoader().getResource("mappings/document-nested-collection.json").toURI())));
        session.setSourceDocument("JSONInstanceNestedCollection", (Object)source);
        context.process(session);
        Assert.assertFalse((String)TestHelper.printAudit(session), (boolean)session.hasErrors());
        Assert.assertFalse((String)TestHelper.printAudit(session), (boolean)session.hasWarns());
        Object output = session.getTargetDocument("JSONInstanceNestedCollection");
        return this.mapper.readTree((String)output);
    }

    private ArrayNode assert1stLevelCollection(JsonNode outputJson, String prettyPrinted) {
        ArrayNode firstArray = (ArrayNode)outputJson.get("firstArray");
        Assert.assertEquals((String)prettyPrinted, (long)2L, (long)firstArray.size());
        Assert.assertEquals((String)prettyPrinted, (Object)"firstArrayValue0", (Object)firstArray.get(0).get("value").asText());
        Assert.assertEquals((String)prettyPrinted, (Object)"firstArrayValue1", (Object)firstArray.get(1).get("value").asText());
        return firstArray;
    }

    private void assert2ndLevelNestedCollection(JsonNode outputJson, String prettyPrinted) {
        ArrayNode firstArray = (ArrayNode)outputJson.get("firstArray");
        Assert.assertEquals((String)prettyPrinted, (long)2L, (long)firstArray.size());
        Assert.assertEquals((String)prettyPrinted, (long)2L, (long)firstArray.get(0).get("secondArray").size());
        Assert.assertEquals((String)prettyPrinted, (Object)"secondArrayValue0-0", (Object)firstArray.get(0).get("secondArray").get(0).get("value").asText());
        Assert.assertEquals((String)prettyPrinted, (Object)"secondArrayValue0-1", (Object)firstArray.get(0).get("secondArray").get(1).get("value").asText());
        Assert.assertEquals((String)prettyPrinted, (long)2L, (long)firstArray.get(1).get("secondArray").size());
        Assert.assertEquals((String)prettyPrinted, (Object)"secondArrayValue1-0", (Object)firstArray.get(1).get("secondArray").get(0).get("value").asText());
        Assert.assertEquals((String)prettyPrinted, (Object)"secondArrayValue1-1", (Object)firstArray.get(1).get("secondArray").get(1).get("value").asText());
    }

    private void assert3rdLevelNestedCollection(JsonNode outputJson, String prettyPrinted) {
        this.assert3rdLevelNestedCollection(outputJson, prettyPrinted, null);
    }

    private void assert3rdLevelNestedCollection(JsonNode outputJson, String prettyPrinted, String suffix) {
        if (suffix == null) {
            suffix = "";
        }
        ArrayNode firstArray = (ArrayNode)outputJson.get("firstArray" + suffix);
        Assert.assertEquals((String)prettyPrinted, (long)2L, (long)firstArray.size());
        JsonNode secondArray0 = firstArray.get(0).get("secondArray" + suffix);
        Assert.assertEquals((String)prettyPrinted, (long)2L, (long)secondArray0.size());
        JsonNode thirdArray00 = secondArray0.get(0).get("thirdArray" + suffix);
        Assert.assertEquals((String)prettyPrinted, (long)2L, (long)thirdArray00.size());
        Assert.assertEquals((String)prettyPrinted, (Object)"thirdArrayValue0-0-0", (Object)thirdArray00.get(0).get("value").asText());
        Assert.assertEquals((String)prettyPrinted, (Object)"thirdArrayValue0-0-1", (Object)thirdArray00.get(1).get("value").asText());
        JsonNode thirdArray01 = secondArray0.get(1).get("thirdArray" + suffix);
        Assert.assertEquals((String)prettyPrinted, (long)3L, (long)thirdArray01.size());
        Assert.assertEquals((String)prettyPrinted, (Object)"thirdArrayValue0-1-0", (Object)thirdArray01.get(0).get("value").asText());
        Assert.assertEquals((String)prettyPrinted, (Object)"thirdArrayValue0-1-1", (Object)thirdArray01.get(1).get("value").asText());
        Assert.assertEquals((String)prettyPrinted, (Object)"thirdArrayValue0-1-2", (Object)thirdArray01.get(2).get("value").asText());
        JsonNode secondArray1 = firstArray.get(1).get("secondArray" + suffix);
        Assert.assertEquals((String)prettyPrinted, (long)2L, (long)secondArray1.size());
        JsonNode thirdArray10 = secondArray1.get(0).get("thirdArray" + suffix);
        Assert.assertEquals((String)prettyPrinted, (long)3L, (long)thirdArray10.size());
        Assert.assertEquals((String)prettyPrinted, (Object)"thirdArrayValue1-0-0", (Object)thirdArray10.get(0).get("value").asText());
        Assert.assertEquals((String)prettyPrinted, (Object)"thirdArrayValue1-0-1", (Object)thirdArray10.get(1).get("value").asText());
        Assert.assertEquals((String)prettyPrinted, (Object)"thirdArrayValue1-0-2", (Object)thirdArray10.get(2).get("value").asText());
        JsonNode thirdArray11 = secondArray1.get(1).get("thirdArray" + suffix);
        Assert.assertEquals((String)prettyPrinted, (long)2L, (long)thirdArray11.size());
        Assert.assertEquals((String)prettyPrinted, (Object)"thirdArrayValue1-1-0", (Object)thirdArray11.get(0).get("value").asText());
        Assert.assertEquals((String)prettyPrinted, (Object)"thirdArrayValue1-1-1", (Object)thirdArray11.get(1).get("value").asText());
    }

    @Test
    public void testAsymmetricFull() throws Exception {
        URL url = Thread.currentThread().getContextClassLoader().getResource("mappings/atlasmapping-nested-collection-asymmetric.json");
        AtlasMapping mapping = this.mappingService.loadMapping(url);
        AtlasContext context = DefaultAtlasContextFactory.getInstance().createContext(mapping);
        AtlasSession session = context.createSession();
        String source = new String(Files.readAllBytes(Paths.get(Thread.currentThread().getContextClassLoader().getResource("mappings/document-nested-collection.json").toURI())));
        session.setSourceDocument("JSONInstanceNestedCollection", (Object)source);
        context.process(session);
        Assert.assertTrue((String)TestHelper.printAudit(session), (boolean)session.hasErrors());
        Assert.assertFalse((String)TestHelper.printAudit(session), (boolean)session.hasWarns());
        Assert.assertTrue((String)TestHelper.printAudit(session), (boolean)((Audit)session.getAudits().getAudit().get(0)).getMessage().contains("/firstArray<>/secondArray<>/value"));
        Assert.assertEquals((String)TestHelper.printAudit(session), (Object)AuditStatus.ERROR, (Object)((Audit)session.getAudits().getAudit().get(0)).getStatus());
        Assert.assertTrue((String)TestHelper.printAudit(session), (boolean)((Audit)session.getAudits().getAudit().get(1)).getMessage().contains("/firstArray<>/secondArray<>/thirdArray<>/value"));
        Assert.assertEquals((String)TestHelper.printAudit(session), (Object)AuditStatus.ERROR, (Object)((Audit)session.getAudits().getAudit().get(1)).getStatus());
    }
}

