/*
 * Decompiled with CFR 0.152.
 */
package io.atlasmap.itests.core.issue;

import io.atlasmap.api.AtlasContext;
import io.atlasmap.api.AtlasSession;
import io.atlasmap.core.AtlasMappingService;
import io.atlasmap.core.DefaultAtlasContextFactory;
import io.atlasmap.itests.core.TestHelper;
import io.atlasmap.itests.core.issue.SourceClass;
import io.atlasmap.itests.core.issue.TargetClass;
import io.atlasmap.v2.AtlasMapping;
import java.net.URL;
import java.text.SimpleDateFormat;
import java.time.Month;
import java.time.ZoneId;
import java.time.ZonedDateTime;
import java.util.Date;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class Atlasmap381Test {
    private AtlasMappingService mappingService;

    @Before
    public void before() {
        this.mappingService = DefaultAtlasContextFactory.getInstance().getMappingService();
    }

    @Test
    public void test() throws Exception {
        URL url = Thread.currentThread().getContextClassLoader().getResource("mappings/issue/atlasmap-381-mapping.json");
        AtlasMapping mapping = this.mappingService.loadMapping(url);
        AtlasContext context = DefaultAtlasContextFactory.getInstance().createContext(mapping);
        AtlasSession session = context.createSession();
        SimpleDateFormat dateFormat = new SimpleDateFormat("YYYY-MM-DD-HH-mm-ss.SSS");
        Date sourceDate = dateFormat.parse("2001-01-01-01-01-01.001");
        session.setSourceDocument("io.atlasmap.itests.core.issue.SourceClass", (Object)new SourceClass().setSourceDate(sourceDate));
        context.process(session);
        Assert.assertFalse((String)TestHelper.printAudit(session), (boolean)session.hasErrors());
        Object output = session.getTargetDocument("io.atlasmap.itests.core.issue.TargetClass");
        Assert.assertEquals(TargetClass.class, output.getClass());
        Date targetDate = ((TargetClass)output).getTargetDate();
        ZonedDateTime localTargetDate = ZonedDateTime.ofInstant(targetDate.toInstant(), ZoneId.systemDefault());
        Assert.assertEquals((Object)Month.FEBRUARY, (Object)localTargetDate.getMonth());
    }
}

