/*
 * Decompiled with CFR 0.152.
 */
package io.atlasmap.itests.core.issue;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import io.atlasmap.api.AtlasContext;
import io.atlasmap.api.AtlasSession;
import io.atlasmap.core.AtlasMappingService;
import io.atlasmap.core.DefaultAtlasContextFactory;
import io.atlasmap.itests.core.TestHelper;
import io.atlasmap.itests.core.issue.Atlasmap759Test;
import io.atlasmap.v2.AtlasMapping;
import java.net.URL;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AtlasMap1241Test {
    private static Logger LOG = LoggerFactory.getLogger(Atlasmap759Test.class);
    private AtlasMappingService mappingService;

    @Before
    public void before() {
        this.mappingService = DefaultAtlasContextFactory.getInstance().getMappingService();
    }

    @Test
    public void test() throws Exception {
        URL url = Thread.currentThread().getContextClassLoader().getResource("mappings/issue/atlasmap-1241-mapping.json");
        AtlasMapping mapping = this.mappingService.loadMapping(url);
        AtlasContext context = DefaultAtlasContextFactory.getInstance().createContext(mapping);
        AtlasSession session = context.createSession();
        session.setSourceDocument("-LqbL_NuYtpimSmmPVQR", (Object)"[{\"id\":1, \"task\":\"first\"},{\"id\":2, \"task\":\"second\"}]");
        context.process(session);
        Assert.assertFalse((String)TestHelper.printAudit(session), (boolean)session.hasErrors());
        Object outputJson = session.getTargetDocument("-LqbLf8BYtpimSmmPVQR");
        Assert.assertNotNull((String)"target-json document was null", (Object)outputJson);
        ObjectMapper om = new ObjectMapper();
        JsonNode expected = om.readTree("{\"id\":3,\"task\":\"first second\"}");
        JsonNode actual = om.readTree((String)outputJson);
        LOG.info(">>> output:target-json >>> {}", (Object)actual.toString());
        Assert.assertTrue((String)actual.toString(), (boolean)expected.equals((Object)actual));
    }
}

