/*
 * Decompiled with CFR 0.152.
 */
package io.atlasmap.itests.core;

import io.atlasmap.api.AtlasContext;
import io.atlasmap.api.AtlasSession;
import io.atlasmap.core.AtlasMappingService;
import io.atlasmap.core.DefaultAtlasContextFactory;
import io.atlasmap.itests.core.BaseClass;
import io.atlasmap.itests.core.SourceClass;
import io.atlasmap.itests.core.TargetClass;
import io.atlasmap.itests.core.TestHelper;
import io.atlasmap.v2.AtlasMapping;
import java.net.URL;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class NestedClassTest {
    private AtlasMappingService mappingService;

    @Before
    public void before() {
        this.mappingService = DefaultAtlasContextFactory.getInstance().getMappingService();
    }

    @Test
    public void test() throws Exception {
        URL url = Thread.currentThread().getContextClassLoader().getResource("mappings/atlasmapping-nested-class.json");
        AtlasMapping mapping = this.mappingService.loadMapping(url);
        AtlasContext context = DefaultAtlasContextFactory.getInstance().createContext(mapping);
        AtlasSession session = context.createSession();
        SourceClass sc = new SourceClass();
        sc.setSomeField("some source class value");
        session.setSourceDocument("io.atlasmap.itests.core.SourceClass", (Object)sc);
        BaseClass.SomeNestedClass sic = new BaseClass.SomeNestedClass();
        sic.setSomeField("some nested class value");
        session.setSourceDocument("io.atlasmap.itests.core.BaseClass$SomeNestedClass", (Object)sic);
        context.process(session);
        Assert.assertFalse((String)TestHelper.printAudit(session), (boolean)session.hasErrors());
        Assert.assertFalse((String)TestHelper.printAudit(session), (boolean)session.hasWarns());
        Object tc = session.getTargetDocument("io.atlasmap.itests.core.TargetClass");
        Assert.assertEquals(TargetClass.class, tc.getClass());
        TargetClass target = (TargetClass)TargetClass.class.cast(tc);
        Assert.assertEquals((Object)"some nested class value", (Object)target.getSomeField());
        Object tsic = session.getTargetDocument("io.atlasmap.itests.core.BaseClass$SomeNestedClass");
        Assert.assertEquals(BaseClass.SomeNestedClass.class, tsic.getClass());
        BaseClass.SomeNestedClass targetSic = (BaseClass.SomeNestedClass)BaseClass.SomeNestedClass.class.cast(tsic);
        Assert.assertEquals((Object)"some source class value", (Object)targetSic.getSomeField());
    }
}

