/*
 * Decompiled with CFR 0.152.
 */
package io.atlasmap.itests.core;

import io.atlasmap.core.DefaultAtlasContext;
import io.atlasmap.core.DefaultAtlasContextFactory;
import io.atlasmap.core.DefaultAtlasSession;
import io.atlasmap.json.module.JsonModule;
import io.atlasmap.json.v2.JsonField;
import io.atlasmap.v2.AtlasMapping;
import io.atlasmap.v2.BaseMapping;
import io.atlasmap.v2.Collection;
import io.atlasmap.v2.Mapping;
import io.atlasmap.v2.MappingType;
import io.atlasmap.v2.Mappings;
import java.lang.reflect.Method;
import java.util.Collections;
import java.util.List;
import org.junit.Assert;
import org.junit.Test;

public class DefaultAtlasContextCollectionExpansionTest {
    @Test
    public void shouldNotExponentialyGrowExpandedCollectionMappings() throws Exception {
        AtlasMapping mapping = new AtlasMapping();
        DefaultAtlasContext context = new DefaultAtlasContext(DefaultAtlasContextFactory.getInstance(), mapping);
        context.setSourceModules(Collections.singletonMap("source", new JsonModule()));
        DefaultAtlasSession session = (DefaultAtlasSession)context.createSession();
        session.setSourceDocument("source", (Object)"{ \"array\": [ { \"property\": 1 }, { \"property\": 2 }, { \"property\": 3 } ] }");
        Collection baseMapping = new Collection();
        baseMapping.setMappingType(MappingType.COLLECTION);
        Mappings mappings = new Mappings();
        Mapping singleMapping = new Mapping();
        singleMapping.setMappingType(MappingType.MAP);
        JsonField nestedArrayField = new JsonField();
        nestedArrayField.setDocId("source");
        nestedArrayField.setPath("/array<>/property");
        singleMapping.getInputField().add(nestedArrayField);
        mappings.getMapping().add(singleMapping);
        baseMapping.setMappings(mappings);
        Method m = context.getClass().getDeclaredMethod("unwrapCollectionMappings", DefaultAtlasSession.class, BaseMapping.class);
        m.setAccessible(true);
        Assert.assertEquals((long)1L, (long)((List)List.class.cast(m.invoke((Object)context, session, baseMapping))).size());
        Assert.assertEquals((long)1L, (long)((List)List.class.cast(m.invoke((Object)context, session, baseMapping))).size());
        Assert.assertEquals((long)1L, (long)((List)List.class.cast(m.invoke((Object)context, session, baseMapping))).size());
    }
}

