/*
 * Decompiled with CFR 0.152.
 */
package io.atlasmap.itests.core;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.SerializationFeature;
import com.fasterxml.jackson.databind.node.ArrayNode;
import io.atlasmap.api.AtlasContext;
import io.atlasmap.api.AtlasSession;
import io.atlasmap.core.AtlasMappingService;
import io.atlasmap.core.DefaultAtlasContextFactory;
import io.atlasmap.itests.core.TestHelper;
import io.atlasmap.v2.AtlasMapping;
import io.atlasmap.v2.Audit;
import io.atlasmap.v2.AuditStatus;
import io.atlasmap.v2.Mapping;
import java.net.URL;
import java.nio.file.Files;
import java.nio.file.Paths;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class NestedCollectionTest {
    private static final Logger LOG = LoggerFactory.getLogger(NestedCollectionTest.class);
    private AtlasMappingService mappingService;
    private ObjectMapper mapper;

    @Before
    public void before() {
        this.mappingService = DefaultAtlasContextFactory.getInstance().getMappingService();
        this.mapper = new ObjectMapper().enable(SerializationFeature.INDENT_OUTPUT).configure(DeserializationFeature.ACCEPT_SINGLE_VALUE_AS_ARRAY, true).setSerializationInclusion(JsonInclude.Include.NON_NULL);
    }

    @Test
    public void testSymmetricFirst() throws Exception {
        URL url = Thread.currentThread().getContextClassLoader().getResource("mappings/atlasmapping-nested-collection-symmetric.json");
        AtlasMapping mapping = this.mappingService.loadMapping(url);
        mapping.getMappings().getMapping().removeIf(m -> !"1-1".equals(((Mapping)m).getId()));
        AtlasContext context = DefaultAtlasContextFactory.getInstance().createContext(mapping);
        AtlasSession session = context.createSession();
        String source = new String(Files.readAllBytes(Paths.get(Thread.currentThread().getContextClassLoader().getResource("mappings/document-nested-collection.json").toURI())));
        session.setSourceDocument("JSONInstanceNestedCollection", (Object)source);
        context.process(session);
        Assert.assertFalse((String)TestHelper.printAudit(session), (boolean)session.hasErrors());
        Assert.assertFalse((String)TestHelper.printAudit(session), (boolean)session.hasWarns());
        Object output = session.getTargetDocument("JSONInstanceNestedCollection");
        Assert.assertEquals(String.class, output.getClass());
        JsonNode outputJson = this.mapper.readTree((String)output);
        String prettyPrinted = this.mapper.writeValueAsString((Object)outputJson);
        ArrayNode firstArray = (ArrayNode)outputJson.get("firstArray");
        Assert.assertEquals((String)prettyPrinted, (long)2L, (long)firstArray.size());
        Assert.assertEquals((String)prettyPrinted, (Object)"firstArrayValue0", (Object)firstArray.get(0).get("value").asText());
        Assert.assertNull((String)prettyPrinted, (Object)firstArray.get(0).get("secondArray"));
        Assert.assertEquals((String)prettyPrinted, (Object)"firstArrayValue1", (Object)firstArray.get(1).get("value").asText());
        Assert.assertNull((String)prettyPrinted, (Object)firstArray.get(1).get("secondArray"));
    }

    @Test
    public void testAsymmetricSingleTarget() throws Exception {
        URL url = Thread.currentThread().getContextClassLoader().getResource("mappings/atlasmapping-nested-collection-asymmetric.json");
        AtlasMapping mapping = this.mappingService.loadMapping(url);
        mapping.getMappings().getMapping().removeIf(m -> !"3-1".equals(((Mapping)m).getId()));
        AtlasContext context = DefaultAtlasContextFactory.getInstance().createContext(mapping);
        AtlasSession session = context.createSession();
        String source = new String(Files.readAllBytes(Paths.get(Thread.currentThread().getContextClassLoader().getResource("mappings/document-nested-collection.json").toURI())));
        session.setSourceDocument("JSONInstanceNestedCollection", (Object)source);
        context.process(session);
        Assert.assertFalse((String)TestHelper.printAudit(session), (boolean)session.hasErrors());
        Assert.assertFalse((String)TestHelper.printAudit(session), (boolean)session.hasWarns());
        Object output = session.getTargetDocument("JSONInstanceNestedCollection");
        Assert.assertEquals(String.class, output.getClass());
        JsonNode outputJson = this.mapper.readTree((String)output);
        String prettyPrinted = this.mapper.writeValueAsString((Object)outputJson);
        ArrayNode firstArray = (ArrayNode)outputJson.get("firstArray");
        Assert.assertEquals((String)prettyPrinted, (long)8L, (long)firstArray.size());
        Assert.assertEquals((String)prettyPrinted, (Object)"thirdArrayValue0-0-0", (Object)firstArray.get(0).get("value").asText());
        Assert.assertNull((String)prettyPrinted, (Object)firstArray.get(0).get("secondArray"));
        Assert.assertEquals((String)prettyPrinted, (Object)"thirdArrayValue0-0-1", (Object)firstArray.get(1).get("value").asText());
        Assert.assertNull((String)prettyPrinted, (Object)firstArray.get(1).get("secondArray"));
        Assert.assertEquals((String)prettyPrinted, (Object)"thirdArrayValue0-1-0", (Object)firstArray.get(2).get("value").asText());
        Assert.assertNull((String)prettyPrinted, (Object)firstArray.get(2).get("secondArray"));
        Assert.assertEquals((String)prettyPrinted, (Object)"thirdArrayValue0-1-1", (Object)firstArray.get(3).get("value").asText());
        Assert.assertNull((String)prettyPrinted, (Object)firstArray.get(3).get("secondArray"));
        Assert.assertEquals((String)prettyPrinted, (Object)"thirdArrayValue1-0-0", (Object)firstArray.get(4).get("value").asText());
        Assert.assertNull((String)prettyPrinted, (Object)firstArray.get(4).get("secondArray"));
        Assert.assertEquals((String)prettyPrinted, (Object)"thirdArrayValue1-0-1", (Object)firstArray.get(5).get("value").asText());
        Assert.assertNull((String)prettyPrinted, (Object)firstArray.get(5).get("secondArray"));
        Assert.assertEquals((String)prettyPrinted, (Object)"thirdArrayValue1-1-0", (Object)firstArray.get(6).get("value").asText());
        Assert.assertNull((String)prettyPrinted, (Object)firstArray.get(6).get("secondArray"));
        Assert.assertEquals((String)prettyPrinted, (Object)"thirdArrayValue1-1-1", (Object)firstArray.get(7).get("value").asText());
        Assert.assertNull((String)prettyPrinted, (Object)firstArray.get(7).get("secondArray"));
    }

    @Test
    public void testSymmetricFull() throws Exception {
        URL url = Thread.currentThread().getContextClassLoader().getResource("mappings/atlasmapping-nested-collection-symmetric.json");
        AtlasMapping mapping = this.mappingService.loadMapping(url);
        AtlasContext context = DefaultAtlasContextFactory.getInstance().createContext(mapping);
        AtlasSession session = context.createSession();
        String source = new String(Files.readAllBytes(Paths.get(Thread.currentThread().getContextClassLoader().getResource("mappings/document-nested-collection.json").toURI())));
        session.setSourceDocument("JSONInstanceNestedCollection", (Object)source);
        context.process(session);
        Assert.assertTrue((String)TestHelper.printAudit(session), (boolean)session.hasErrors());
        Assert.assertFalse((String)TestHelper.printAudit(session), (boolean)session.hasWarns());
        Assert.assertEquals((long)2L, (long)session.getAudits().getAudit().size());
        Assert.assertTrue((String)TestHelper.printAudit(session), (boolean)((Audit)session.getAudits().getAudit().get(0)).getMessage().contains("/firstArray<>/secondArray<>/value"));
        Assert.assertEquals((String)TestHelper.printAudit(session), (Object)AuditStatus.ERROR, (Object)((Audit)session.getAudits().getAudit().get(0)).getStatus());
        Assert.assertTrue((String)TestHelper.printAudit(session), (boolean)((Audit)session.getAudits().getAudit().get(1)).getMessage().contains("/firstArray<>/secondArray<>/thirdArray<>/value"));
        Assert.assertEquals((String)TestHelper.printAudit(session), (Object)AuditStatus.ERROR, (Object)((Audit)session.getAudits().getAudit().get(1)).getStatus());
    }

    @Test
    public void testAsymmetricFull() throws Exception {
        URL url = Thread.currentThread().getContextClassLoader().getResource("mappings/atlasmapping-nested-collection-asymmetric.json");
        AtlasMapping mapping = this.mappingService.loadMapping(url);
        AtlasContext context = DefaultAtlasContextFactory.getInstance().createContext(mapping);
        AtlasSession session = context.createSession();
        String source = new String(Files.readAllBytes(Paths.get(Thread.currentThread().getContextClassLoader().getResource("mappings/document-nested-collection.json").toURI())));
        session.setSourceDocument("JSONInstanceNestedCollection", (Object)source);
        context.process(session);
        Assert.assertTrue((String)TestHelper.printAudit(session), (boolean)session.hasErrors());
        Assert.assertFalse((String)TestHelper.printAudit(session), (boolean)session.hasWarns());
        Assert.assertTrue((String)TestHelper.printAudit(session), (boolean)((Audit)session.getAudits().getAudit().get(0)).getMessage().contains("/firstArray<>/secondArray<>/value"));
        Assert.assertEquals((String)TestHelper.printAudit(session), (Object)AuditStatus.ERROR, (Object)((Audit)session.getAudits().getAudit().get(0)).getStatus());
        Assert.assertTrue((String)TestHelper.printAudit(session), (boolean)((Audit)session.getAudits().getAudit().get(1)).getMessage().contains("/firstArray<>/secondArray<>/thirdArray<>/value"));
        Assert.assertEquals((String)TestHelper.printAudit(session), (Object)AuditStatus.ERROR, (Object)((Audit)session.getAudits().getAudit().get(1)).getStatus());
    }
}

