/*
 * Decompiled with CFR 0.152.
 */
package io.atlasmap.itests.core.issue;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import io.atlasmap.api.AtlasContext;
import io.atlasmap.api.AtlasSession;
import io.atlasmap.core.AtlasMappingService;
import io.atlasmap.core.DefaultAtlasContextFactory;
import io.atlasmap.itests.core.TestHelper;
import io.atlasmap.itests.core.issue.Atlasmap759Test;
import io.atlasmap.itests.core.issue.TargetClass;
import io.atlasmap.v2.AtlasMapping;
import java.net.URL;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.xmlunit.assertj.XmlAssert;

public class AtlasMap846Test {
    private static Logger LOG = LoggerFactory.getLogger(Atlasmap759Test.class);
    private AtlasMappingService mappingService;

    @Before
    public void before() {
        this.mappingService = DefaultAtlasContextFactory.getInstance().getMappingService();
    }

    @Test
    public void test() throws Exception {
        URL url = Thread.currentThread().getContextClassLoader().getResource("mappings/issue/atlasmap-846-mapping.json");
        AtlasMapping mapping = this.mappingService.loadMapping(url);
        AtlasContext context = DefaultAtlasContextFactory.getInstance().createContext(mapping);
        AtlasSession session = context.createSession();
        session.setSourceDocument("source", (Object)"[]");
        context.process(session);
        Assert.assertFalse((String)TestHelper.printAudit(session), (boolean)session.hasErrors());
        Object outputJson = session.getTargetDocument("target-json");
        Assert.assertNotNull((String)"target-json document was null", (Object)outputJson);
        ObjectMapper om = new ObjectMapper();
        JsonNode expected = om.readTree("{\"body\":[],\"three\":[]}");
        JsonNode actual = om.readTree((String)outputJson);
        LOG.info(">>> output:target-json >>> {}", (Object)actual.toString());
        Assert.assertTrue((String)actual.toString(), (boolean)expected.equals((Object)actual));
        Object outputXml = session.getTargetDocument("target-xml");
        Assert.assertNotNull((String)"target-xml document was null", (Object)outputXml);
        XmlAssert.assertThat((Object)outputXml).nodesByXPath("/root").exist();
        LOG.info(">>> output:target-xml >>> {}", (Object)outputXml.toString());
        Object outputJava = session.getTargetDocument("target-java");
        Assert.assertNotNull((String)"target-java document was null", (Object)outputJava);
        Assert.assertEquals(TargetClass.class, outputJava.getClass());
        TargetClass targetClass = (TargetClass)outputJava;
        Assert.assertEquals((long)0L, (long)targetClass.getTargetList().size());
        Assert.assertEquals((long)0L, (long)targetClass.getTargetStringList().size());
    }

    @Test
    public void testHappyPath() throws Exception {
        URL url = Thread.currentThread().getContextClassLoader().getResource("mappings/issue/atlasmap-846-mapping.json");
        AtlasMapping mapping = this.mappingService.loadMapping(url);
        AtlasContext context = DefaultAtlasContextFactory.getInstance().createContext(mapping);
        AtlasSession session = context.createSession();
        session.setSourceDocument("source", (Object)"[{\"first_name\":\"Tom\",\"last_name\":\"Silva\",\"three\":\"three\"}]");
        context.process(session);
        Assert.assertFalse((String)TestHelper.printAudit(session), (boolean)session.hasErrors());
        Object outputJson = session.getTargetDocument("target-json");
        Assert.assertNotNull((String)"target-json document was null", (Object)outputJson);
        ObjectMapper om = new ObjectMapper();
        JsonNode expected = om.readTree("{\"body\":[{\"A\":\"Tom\",\"B\":\"Silva\"}],\"three\":[\"three\"]}");
        JsonNode actual = om.readTree((String)outputJson);
        LOG.info(">>> output:target-json >>> {}", (Object)actual.toString());
        Assert.assertTrue((String)actual.toString(), (boolean)expected.equals((Object)actual));
        Object outputXml = session.getTargetDocument("target-xml");
        Assert.assertNotNull((String)"target-xml document was null", (Object)outputXml);
        XmlAssert.assertThat((Object)outputXml).valueByXPath("/root/body/A").isEqualTo((Object)"Tom");
        XmlAssert.assertThat((Object)outputXml).valueByXPath("/root/body/B").isEqualTo((Object)"Silva");
        XmlAssert.assertThat((Object)outputXml).valueByXPath("/root/three").isEqualTo((Object)"three");
        LOG.info(">>> output:target-xml >>> {}", (Object)outputXml.toString());
        Object outputJava = session.getTargetDocument("target-java");
        Assert.assertNotNull((String)"target-java document was null", (Object)outputJava);
        Assert.assertEquals(TargetClass.class, outputJava.getClass());
        TargetClass targetClass = (TargetClass)outputJava;
        Assert.assertEquals((long)1L, (long)targetClass.getTargetList().size());
        Assert.assertEquals((long)1L, (long)targetClass.getTargetStringList().size());
    }
}

