/*
 * Decompiled with CFR 0.152.
 */
package io.atlasmap.itests.core;

import io.atlasmap.core.AtlasMappingService;
import io.atlasmap.core.DefaultAtlasContextFactory;
import io.atlasmap.v2.AtlasMapping;
import io.atlasmap.v2.BaseMapping;
import io.atlasmap.v2.Field;
import io.atlasmap.v2.Mapping;
import io.atlasmap.v2.MappingType;
import java.io.File;
import java.io.InputStreamReader;
import java.io.Reader;
import java.net.URL;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class AtlasMappingServiceTest {
    private AtlasMappingService mappingService;

    @Before
    public void before() {
        this.mappingService = DefaultAtlasContextFactory.getInstance().getMappingService();
    }

    @Test
    public void testMappingXML() throws Exception {
        URL url = Thread.currentThread().getContextClassLoader().getResource("mappings/atlasmapping.json");
        this.assertAtlasMapping(this.mappingService.loadMapping(url));
        this.assertAtlasMapping(this.mappingService.loadMapping(url.toURI()));
        this.assertAtlasMapping(this.mappingService.loadMapping(new File(url.toURI())));
        this.assertAtlasMapping(this.mappingService.loadMapping(url.openStream()));
        this.assertAtlasMapping(this.mappingService.loadMapping((Reader)new InputStreamReader(url.openStream())));
        File outputXml = new File("target/output-atlasmapping.xml");
        this.mappingService.saveMappingAsFile(this.mappingService.loadMapping(url), outputXml);
        this.assertAtlasMapping(this.mappingService.loadMapping(outputXml));
    }

    @Test
    public void testMappingXMLViaContext() throws Exception {
        URL url = Thread.currentThread().getContextClassLoader().getResource("mappings/atlasmapping.json");
        this.assertAtlasMapping(DefaultAtlasContextFactory.getInstance().createContext(url.toURI()).createSession().getMapping());
        this.assertAtlasMapping(DefaultAtlasContextFactory.getInstance().createContext(new File(url.toURI())).createSession().getMapping());
        this.assertAtlasMapping(DefaultAtlasContextFactory.getInstance().createContext(url.toURI()).createSession().getMapping());
        this.assertAtlasMapping(DefaultAtlasContextFactory.getInstance().createContext(new File(url.toURI())).createSession().getMapping());
    }

    @Test
    public void testMappingJSON() throws Exception {
        URL url = Thread.currentThread().getContextClassLoader().getResource("mappings/atlasmapping.json");
        this.assertAtlasMapping(this.mappingService.loadMapping(url));
        this.assertAtlasMapping(this.mappingService.loadMapping(url.toURI()));
        this.assertAtlasMapping(this.mappingService.loadMapping(new File(url.toURI())));
        this.assertAtlasMapping(this.mappingService.loadMapping(url.openStream()));
        this.assertAtlasMapping(this.mappingService.loadMapping((Reader)new InputStreamReader(url.openStream())));
        File outputJson = new File("target/output-atlasmapping.json");
        this.mappingService.saveMappingAsFile(this.mappingService.loadMapping(url), outputJson);
        this.assertAtlasMapping(this.mappingService.loadMapping(outputJson));
    }

    @Test
    public void testMappingJSONViaContext() throws Exception {
        URL url = Thread.currentThread().getContextClassLoader().getResource("mappings/atlasmapping.json");
        this.assertAtlasMapping(DefaultAtlasContextFactory.getInstance().createContext(url.toURI()).createSession().getMapping());
        this.assertAtlasMapping(DefaultAtlasContextFactory.getInstance().createContext(new File(url.toURI())).createSession().getMapping());
    }

    private void assertAtlasMapping(AtlasMapping mapping) {
        Assert.assertNotNull((Object)mapping);
        Assert.assertEquals((Object)"core.unit.test", (Object)mapping.getName());
        Assert.assertNotNull((Object)mapping.getMappings());
        Assert.assertNotNull((Object)mapping.getMappings().getMapping());
        Assert.assertNotNull(mapping.getMappings().getMapping().get(0));
        BaseMapping m = (BaseMapping)mapping.getMappings().getMapping().get(0);
        Assert.assertEquals((Object)MappingType.MAP, (Object)m.getMappingType());
        Assert.assertEquals(Mapping.class, m.getClass());
        Assert.assertNotNull((Object)((Mapping)m).getInputField());
        Field input = (Field)((Mapping)m).getInputField().get(0);
        Assert.assertEquals((Object)"/orderId", (Object)input.getPath());
        Assert.assertNotNull((Object)((Mapping)m).getOutputField());
        Field output = (Field)((Mapping)m).getOutputField().get(0);
        Assert.assertEquals((Object)"/orderId", (Object)output.getPath());
    }
}

