/*
 * Decompiled with CFR 0.152.
 */
package io.atlasmap.itests.core;

import io.atlasmap.api.AtlasContext;
import io.atlasmap.api.AtlasSession;
import io.atlasmap.core.AtlasMappingService;
import io.atlasmap.core.DefaultAtlasContextFactory;
import io.atlasmap.itests.core.TestHelper;
import io.atlasmap.itests.core.issue.SourceClass;
import io.atlasmap.itests.core.issue.TargetClass;
import io.atlasmap.v2.AtlasMapping;
import io.atlasmap.v2.AuditStatus;
import java.net.URL;
import java.util.Arrays;
import java.util.List;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class MultiplicityTransformationTest {
    private AtlasMappingService mappingService;

    @Before
    public void before() {
        this.mappingService = DefaultAtlasContextFactory.getInstance().getMappingService();
    }

    @Test
    public void testConcatenateSplit() throws Exception {
        URL url = Thread.currentThread().getContextClassLoader().getResource("mappings/atlasmapping-multiplicity-transformation-concatenate-split.json");
        AtlasMapping mapping = this.mappingService.loadMapping(url);
        AtlasContext context = DefaultAtlasContextFactory.getInstance().createContext(mapping);
        AtlasSession session = context.createSession();
        SourceClass source = new SourceClass().setSourceFirstName("Manjiro").setSourceLastName("Nakahama").setSourceName("Manjiro,Nakahama").setSourceString("one,two,three").setSourceStringList(Arrays.asList("one", "two", "three")).setSourceHiphenatedInteger("1-20-300-4000").setSourceStreet("314 Littleton Rd").setSourceWeight("128.965 kg");
        session.setSourceDocument("io.atlasmap.itests.core.issue.SourceClass", (Object)source);
        context.process(session);
        Assert.assertFalse((String)TestHelper.printAudit(session), (boolean)session.hasErrors());
        Assert.assertTrue((String)"split(STRING) => INTEGER/DOUBLE mapping should get warnings", (boolean)session.hasWarns());
        Assert.assertEquals((long)8L, (long)session.getAudits().getAudit().stream().filter(a -> a.getStatus() == AuditStatus.WARN).count());
        Object output = session.getTargetDocument("io.atlasmap.itests.core.issue.TargetClass");
        Assert.assertEquals(TargetClass.class, output.getClass());
        TargetClass target = (TargetClass)TargetClass.class.cast(output);
        Assert.assertEquals((Object)"Manjiro", (Object)target.getTargetFirstName());
        Assert.assertEquals((Object)"Nakahama", (Object)target.getTargetLastName());
        Assert.assertEquals((Object)"Manjiro,Nakahama", (Object)target.getTargetName());
        Assert.assertEquals((Object)"one,two,three", (Object)target.getTargetString());
        Assert.assertEquals((Object)new Integer(314), (Object)target.getTargetStreetNumber());
        Assert.assertEquals((Object)"Littleton", (Object)target.getTargetStreetName1());
        Assert.assertEquals((Object)"Rd", (Object)target.getTargetStreetName2());
        List<String> list = target.getTargetStringList();
        Assert.assertEquals((long)3L, (long)list.size());
        Assert.assertEquals((Object)"one", (Object)list.get(0));
        Assert.assertEquals((Object)"two", (Object)list.get(1));
        Assert.assertEquals((Object)"three", (Object)list.get(2));
        List<Integer> intList = target.getTargetIntegerList();
        Assert.assertEquals((long)4L, (long)intList.size());
        Assert.assertEquals((Object)new Integer(1), (Object)intList.get(0));
        Assert.assertEquals((Object)new Integer(20), (Object)intList.get(1));
        Assert.assertEquals((Object)new Integer(300), (Object)intList.get(2));
        Assert.assertEquals((Object)new Integer(4000), (Object)intList.get(3));
        Assert.assertEquals((Object)128.965, (Object)target.getTargetWeightDouble());
        Assert.assertEquals((Object)"kg", (Object)target.getTargetWeightUnit());
    }

    @Test
    public void testItemAt() throws Exception {
        URL url = Thread.currentThread().getContextClassLoader().getResource("mappings/atlasmapping-multiplicity-transformation-itemAt.json");
        AtlasMapping mapping = this.mappingService.loadMapping(url);
        AtlasContext context = DefaultAtlasContextFactory.getInstance().createContext(mapping);
        AtlasSession session = context.createSession();
        SourceClass source = new SourceClass().setSourceStringList(Arrays.asList("one", "two", "three"));
        session.setSourceDocument("io.atlasmap.itests.core.issue.SourceClass", (Object)source);
        context.process(session);
        Assert.assertFalse((String)TestHelper.printAudit(session), (boolean)session.hasErrors());
        Assert.assertFalse((String)TestHelper.printAudit(session), (boolean)session.hasWarns());
        Object output = session.getTargetDocument("io.atlasmap.itests.core.issue.TargetClass");
        Assert.assertEquals(TargetClass.class, output.getClass());
        TargetClass target = (TargetClass)TargetClass.class.cast(output);
        Assert.assertEquals((Object)"two", (Object)target.getTargetString());
    }

    @Test
    public void testExpression() throws Exception {
        URL url = Thread.currentThread().getContextClassLoader().getResource("mappings/atlasmapping-multiplicity-transformation-expression.json");
        AtlasMapping mapping = this.mappingService.loadMapping(url);
        AtlasContext context = DefaultAtlasContextFactory.getInstance().createContext(mapping);
        AtlasSession session = context.createSession();
        SourceClass source = new SourceClass().setSourceString("").setSourceInteger(123).setSourceFirstName(null).setSourceLastName("").setSourceInteger2(-123);
        session.setSourceDocument("io.atlasmap.itests.core.issue.SourceClass", (Object)source);
        context.process(session);
        Assert.assertFalse((String)TestHelper.printAudit(session), (boolean)session.hasErrors());
        Assert.assertFalse((String)TestHelper.printAudit(session), (boolean)session.hasWarns());
        Object output = session.getTargetDocument("io.atlasmap.itests.core.issue.TargetClass");
        Assert.assertEquals(TargetClass.class, output.getClass());
        TargetClass target = (TargetClass)TargetClass.class.cast(output);
        Assert.assertEquals((Object)"one-two-three", (Object)target.getTargetString());
        Assert.assertEquals((long)123L, (long)target.getTargetInteger());
        Assert.assertEquals((Object)"last name is empty", (Object)target.getTargetName());
        Assert.assertEquals((Object)"true", (Object)target.getTargetFirstName());
        session = context.createSession();
        source = new SourceClass().setSourceString("not empty").setSourceInteger(789).setSourceFirstName(null).setSourceLastName("lastname").setSourceInteger2(790);
        session.setSourceDocument("io.atlasmap.itests.core.issue.SourceClass", (Object)source);
        context.process(session);
        Assert.assertFalse((String)TestHelper.printAudit(session), (boolean)session.hasErrors());
        Assert.assertFalse((String)TestHelper.printAudit(session), (boolean)session.hasWarns());
        output = session.getTargetDocument("io.atlasmap.itests.core.issue.TargetClass");
        Assert.assertEquals(TargetClass.class, output.getClass());
        target = (TargetClass)TargetClass.class.cast(output);
        Assert.assertEquals((Object)"not one-two-three", (Object)target.getTargetString());
        Assert.assertEquals((long)456L, (long)target.getTargetInteger());
        Assert.assertEquals((Object)"last name is not empty", (Object)target.getTargetName());
        Assert.assertEquals((Object)"false", (Object)target.getTargetFirstName());
    }
}

