/*
 * Decompiled with CFR 0.152.
 */
package io.atlasmap.itests.core;

import io.atlasmap.api.AtlasContext;
import io.atlasmap.api.AtlasSession;
import io.atlasmap.core.AtlasMappingService;
import io.atlasmap.core.DefaultAtlasContextFactory;
import io.atlasmap.itests.core.TestHelper;
import io.atlasmap.itests.core.issue.SourceClass;
import io.atlasmap.itests.core.issue.TargetClass;
import io.atlasmap.v2.AtlasMapping;
import java.net.URL;
import java.util.Arrays;
import java.util.List;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class MultiplicityTransformationTest {
    private AtlasMappingService mappingService;

    @Before
    public void before() {
        this.mappingService = DefaultAtlasContextFactory.getInstance().getMappingService();
    }

    @Test
    public void testConcatenateSplit() throws Exception {
        URL url = Thread.currentThread().getContextClassLoader().getResource("mappings/atlasmapping-multiplicity-transformation-concatenate-split.json");
        AtlasMapping mapping = this.mappingService.loadMapping(url);
        AtlasContext context = DefaultAtlasContextFactory.getInstance().createContext(mapping);
        AtlasSession session = context.createSession();
        SourceClass source = new SourceClass().setSourceFirstName("Manjiro").setSourceLastName("Nakahama").setSourceName("Manjiro,Nakahama").setSourceString("one,two,three").setSourceStringList(Arrays.asList("one", "two", "three"));
        session.setSourceDocument("io.atlasmap.itests.core.issue.SourceClass", (Object)source);
        context.process(session);
        Assert.assertFalse((String)TestHelper.printAudit(session), (boolean)session.hasErrors());
        Assert.assertFalse((String)TestHelper.printAudit(session), (boolean)session.hasWarns());
        Object output = session.getTargetDocument("io.atlasmap.itests.core.issue.TargetClass");
        Assert.assertEquals(TargetClass.class, output.getClass());
        TargetClass target = (TargetClass)TargetClass.class.cast(output);
        Assert.assertEquals((Object)"Manjiro", (Object)target.getTargetFirstName());
        Assert.assertEquals((Object)"Nakahama", (Object)target.getTargetLastName());
        Assert.assertEquals((Object)"Manjiro,Nakahama", (Object)target.getTargetName());
        Assert.assertEquals((Object)"one,two,three", (Object)target.getTargetString());
        List<String> list = target.getTargetStringList();
        Assert.assertEquals((long)3L, (long)list.size());
        Assert.assertEquals((Object)"one", (Object)list.get(0));
        Assert.assertEquals((Object)"two", (Object)list.get(1));
        Assert.assertEquals((Object)"three", (Object)list.get(2));
    }

    @Test
    public void testItemAt() throws Exception {
        URL url = Thread.currentThread().getContextClassLoader().getResource("mappings/atlasmapping-multiplicity-transformation-itemAt.json");
        AtlasMapping mapping = this.mappingService.loadMapping(url);
        AtlasContext context = DefaultAtlasContextFactory.getInstance().createContext(mapping);
        AtlasSession session = context.createSession();
        SourceClass source = new SourceClass().setSourceStringList(Arrays.asList("one", "two", "three"));
        session.setSourceDocument("io.atlasmap.itests.core.issue.SourceClass", (Object)source);
        context.process(session);
        Assert.assertFalse((String)TestHelper.printAudit(session), (boolean)session.hasErrors());
        Assert.assertFalse((String)TestHelper.printAudit(session), (boolean)session.hasWarns());
        Object output = session.getTargetDocument("io.atlasmap.itests.core.issue.TargetClass");
        Assert.assertEquals(TargetClass.class, output.getClass());
        TargetClass target = (TargetClass)TargetClass.class.cast(output);
        Assert.assertEquals((Object)"two", (Object)target.getTargetString());
    }
}

