/*
 * Decompiled with CFR 0.152.
 */
package io.atlasmap.core.issue;

import io.atlasmap.api.AtlasContext;
import io.atlasmap.api.AtlasSession;
import io.atlasmap.core.AtlasMappingService;
import io.atlasmap.core.DefaultAtlasContextFactory;
import io.atlasmap.core.TestHelper;
import io.atlasmap.core.issue.TargetClass;
import io.atlasmap.v2.AtlasMapping;
import java.net.URL;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class ConstantPropertyTest {
    private AtlasMappingService mappingService;

    @Before
    public void before() {
        this.mappingService = DefaultAtlasContextFactory.getInstance().getMappingService();
    }

    @Test
    public void test() throws Exception {
        URL url = Thread.currentThread().getContextClassLoader().getResource("mappings/issue/constant-property-mapping.xml");
        AtlasMapping mapping = this.mappingService.loadMapping(url, AtlasMappingService.AtlasMappingFormat.XML);
        AtlasContext context = DefaultAtlasContextFactory.getInstance().createContext(mapping);
        AtlasSession session = context.createSession();
        context.process(session);
        Assert.assertFalse((String)TestHelper.printAudit(session), (boolean)session.hasErrors());
        TargetClass output = (TargetClass)TargetClass.class.cast(session.getTargetDocument("io.atlasmap.core.issue.TargetClass"));
        Assert.assertEquals((Object)"testValue", (Object)output.getTargetName());
        Assert.assertNotEquals((Object)"testPath", (Object)output.getTargetFirstName());
        Assert.assertEquals((long)777L, (long)output.getTargetInteger());
        System.setProperty("testProp", "testProp-sysProp");
        System.setProperty("PATH", "PATH-sysProp");
        context.process(session);
        Assert.assertFalse((String)TestHelper.printAudit(session), (boolean)session.hasErrors());
        output = (TargetClass)TargetClass.class.cast(session.getTargetDocument("io.atlasmap.core.issue.TargetClass"));
        Assert.assertEquals((Object)"testProp-sysProp", (Object)output.getTargetName());
        Assert.assertEquals((Object)"PATH-sysProp", (Object)output.getTargetFirstName());
        Assert.assertEquals((long)777L, (long)output.getTargetInteger());
        session.getProperties().put("testProp", "testProp-runtimeProp");
        session.getProperties().put("PATH", "PATH-runtimeProp");
        context.process(session);
        Assert.assertFalse((String)TestHelper.printAudit(session), (boolean)session.hasErrors());
        output = (TargetClass)TargetClass.class.cast(session.getTargetDocument("io.atlasmap.core.issue.TargetClass"));
        Assert.assertEquals((Object)"testProp-runtimeProp", (Object)output.getTargetName());
        Assert.assertEquals((Object)"PATH-runtimeProp", (Object)output.getTargetFirstName());
        Assert.assertEquals((long)777L, (long)output.getTargetInteger());
    }
}

