/*
 * Decompiled with CFR 0.152.
 */
package io.atlasmap.core.issue;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import io.atlasmap.api.AtlasContext;
import io.atlasmap.api.AtlasSession;
import io.atlasmap.core.AtlasMappingService;
import io.atlasmap.core.DefaultAtlasContextFactory;
import io.atlasmap.core.TestHelper;
import io.atlasmap.v2.AtlasMapping;
import java.net.URL;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.mockito.Mockito;
import twitter4j.Status;
import twitter4j.User;

public class CamelAtlasmap14Test {
    private AtlasMappingService mappingService;

    @Before
    public void before() {
        this.mappingService = DefaultAtlasContextFactory.getInstance().getMappingService();
    }

    @Test
    public void test() throws Exception {
        URL url = Thread.currentThread().getContextClassLoader().getResource("mappings/issue/camel-atlasmap-14-mapping.json");
        AtlasMapping mapping = this.mappingService.loadMapping(url, AtlasMappingService.AtlasMappingFormat.JSON);
        AtlasContext context = DefaultAtlasContextFactory.getInstance().createContext(mapping);
        AtlasSession session = context.createSession();
        session.setDefaultSourceDocument((Object)this.generateTwitterStatus());
        context.process(session);
        Assert.assertFalse((String)TestHelper.printAudit(session), (boolean)session.hasErrors());
        Object output = session.getDefaultTargetDocument();
        Assert.assertEquals(String.class, output.getClass());
        ObjectMapper mapper = new ObjectMapper();
        JsonNode outJson = mapper.readTree((String)output);
        Assert.assertNotNull((Object)outJson.get("TwitterScreenName__c"));
        Assert.assertEquals((Object)"bobvila1982", (Object)outJson.get("TwitterScreenName__c").asText());
    }

    protected Status generateTwitterStatus() {
        Status status = (Status)Mockito.mock(Status.class);
        User user = (User)Mockito.mock(User.class);
        Mockito.when((Object)user.getName()).thenReturn((Object)"Bob Vila");
        Mockito.when((Object)user.getScreenName()).thenReturn((Object)"bobvila1982");
        Mockito.when((Object)status.getUser()).thenReturn((Object)user);
        Mockito.when((Object)status.getText()).thenReturn((Object)"Let's build a house!");
        return status;
    }
}

