/*
 * Decompiled with CFR 0.152.
 */
package io.atlasmap.core;

import io.atlasmap.api.AtlasException;
import io.atlasmap.core.DefaultAtlasContext;
import io.atlasmap.core.DefaultAtlasContextFactory;
import io.atlasmap.core.DefaultAtlasSession;
import io.atlasmap.json.module.JsonModule;
import io.atlasmap.json.v2.JsonField;
import io.atlasmap.v2.AtlasMapping;
import io.atlasmap.v2.BaseMapping;
import io.atlasmap.v2.Collection;
import io.atlasmap.v2.Mapping;
import io.atlasmap.v2.MappingType;
import io.atlasmap.v2.Mappings;
import java.util.Collections;
import org.junit.Assert;
import org.junit.Test;

public class DefaultAtlasContextCollectionExpansionTest {
    @Test
    public void shouldNotExponentialyGrowExpandedCollectionMappings() throws AtlasException {
        AtlasMapping mapping = new AtlasMapping();
        DefaultAtlasContext context = new DefaultAtlasContext(new DefaultAtlasContextFactory(), mapping);
        context.setSourceModules(Collections.singletonMap("source", new JsonModule()));
        DefaultAtlasSession session = new DefaultAtlasSession(mapping);
        session.setSourceDocument("source", (Object)"{ \"array\": [ { \"property\": 1 }, { \"property\": 2 }, { \"property\": 3 } ] }");
        Collection baseMapping = new Collection();
        baseMapping.setMappingType(MappingType.COLLECTION);
        Mappings mappings = new Mappings();
        Mapping singleMapping = new Mapping();
        singleMapping.setMappingType(MappingType.MAP);
        JsonField nestedArrayField = new JsonField();
        nestedArrayField.setDocId("source");
        nestedArrayField.setPath("/array<>/property");
        singleMapping.getInputField().add(nestedArrayField);
        mappings.getMapping().add(singleMapping);
        baseMapping.setMappings(mappings);
        Assert.assertEquals((long)3L, (long)context.extractCollectionMappings(session, (BaseMapping)baseMapping).size());
        Assert.assertEquals((long)3L, (long)context.extractCollectionMappings(session, (BaseMapping)baseMapping).size());
        Assert.assertEquals((long)3L, (long)context.extractCollectionMappings(session, (BaseMapping)baseMapping).size());
    }
}

