/*
 * Decompiled with CFR 0.152.
 */
package io.atlasmap.core.issue;

import io.atlasmap.api.AtlasContext;
import io.atlasmap.api.AtlasSession;
import io.atlasmap.core.AtlasMappingService;
import io.atlasmap.core.DefaultAtlasContextFactory;
import io.atlasmap.core.TestHelper;
import io.atlasmap.core.issue.Item;
import io.atlasmap.core.issue.SourceClass;
import io.atlasmap.core.issue.TargetClass;
import io.atlasmap.v2.AtlasMapping;
import java.net.URL;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class CollectionComplexTest {
    private AtlasMappingService mappingService;

    @Before
    public void before() {
        this.mappingService = DefaultAtlasContextFactory.getInstance().getMappingService();
    }

    @Test
    public void test() throws Exception {
        URL url = Thread.currentThread().getContextClassLoader().getResource("mappings/issue/collection-complex-mapping.xml");
        AtlasMapping mapping = this.mappingService.loadMapping(url, AtlasMappingService.AtlasMappingFormat.XML);
        AtlasContext context = DefaultAtlasContextFactory.getInstance().createContext(mapping);
        AtlasSession session = context.createSession();
        SourceClass sourceClass = new SourceClass().setSourceName("javaSourceName");
        sourceClass.getSourceList().add(new Item().setName("java1"));
        sourceClass.getSourceList().add(new Item().setName("java2"));
        sourceClass.getSourceList().add(new Item().setName("java3"));
        session.setSourceDocument("SourceClass", (Object)sourceClass);
        session.setSourceDocument("SourceJson", (Object)"{\"sourceList\":[\"json1\", \"json2\", \"json3\"]}");
        session.setSourceDocument("SourceXml", (Object)"<root><sourceList><name>xml1</name></sourceList><sourceList><name>xml2</name></sourceList><sourceList><name>xml3</name></sourceList></root>");
        context.process(session);
        Assert.assertFalse((String)TestHelper.printAudit(session), (boolean)session.hasErrors());
        Object targetJava = session.getTargetDocument("TargetClass");
        Assert.assertEquals(TargetClass.class, targetJava.getClass());
        Assert.assertEquals((Object)"xml3", (Object)((TargetClass)targetJava).getTargetName());
        Object targetJson = session.getTargetDocument("TargetJson");
        Assert.assertEquals((Object)"{\"javaList\":[{\"name\":\"java1\"},{\"name\":\"java2\"},{\"name\":\"java3\"}]}", (Object)targetJson);
        Object targetXml = session.getTargetDocument("TargetXml");
        Assert.assertEquals((Object)"<?xml version=\"1.0\" encoding=\"UTF-8\" standalone=\"no\"?><root><javaList><name>java1</name></javaList><javaList><name>java2</name></javaList><javaList><name>java3</name></javaList><jsonList/><jsonList/><jsonList/></root>", (Object)targetXml);
    }
}

