/*
 * Decompiled with CFR 0.152.
 */
package io.atlasmap.expression;

import io.atlasmap.expression.Expression;
import io.atlasmap.expression.ExpressionContext;
import io.atlasmap.expression.ExpressionException;
import io.atlasmap.expression.FunctionResolver;
import io.atlasmap.expression.internal.BooleanExpression;
import io.atlasmap.expression.internal.ComparisonExpression;
import io.atlasmap.expression.parser.ParseException;
import io.atlasmap.v2.AtlasModelFactory;
import io.atlasmap.v2.Field;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.HashMap;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class ExpressionTest {
    static final FunctionResolver FUNCTION_RESOLVER = (name, args) -> {
        if ("LT".equals(name = name.toUpperCase())) {
            if (args.size() != 2) {
                throw new ParseException("LT expects 2 arguments.");
            }
            return ComparisonExpression.createLessThan((Expression)((Expression)args.get(0)), (Expression)((Expression)args.get(1)));
        }
        if ("IF".equals(name)) {
            if (args.size() != 3) {
                throw new ParseException("IF expects 3 argument.");
            }
            BooleanExpression conditional = BooleanExpression.asBooleanExpression((Expression)((Expression)args.get(0)));
            Expression trueExpression = (Expression)args.get(1);
            Expression falseExpression = (Expression)args.get(2);
            return ctx -> {
                if (conditional.matches(ctx)) {
                    return trueExpression.evaluate(ctx);
                }
                return falseExpression.evaluate(ctx);
            };
        }
        if ("TOLOWER".equals(name)) {
            if (args.size() != 1) {
                throw new ParseException("TOLOWER expects 1 argument.");
            }
            Expression arg = (Expression)args.get(0);
            return ctx -> {
                Object value = arg.evaluate(ctx).getValue();
                if (value == null) {
                    return AtlasModelFactory.wrapWithField(null);
                }
                return AtlasModelFactory.wrapWithField((Object)value.toString().toLowerCase());
            };
        }
        if ("CONCATENATE".equals(name)) {
            if (args.size() < 3) {
                throw new ParseException("CONCATENATE expects at least 3 arguments.");
            }
            return ctx -> {
                Object value = "";
                String delimiter = ((Expression)args.get(0)).evaluate(ctx).getValue().toString();
                for (int i = 1; i < args.size(); ++i) {
                    value = (String)value + (i == 1 ? "" : delimiter) + ((Expression)args.get(i)).evaluate(ctx).getValue();
                }
                return AtlasModelFactory.wrapWithField((Object)value);
            };
        }
        throw new ParseException("Unknown function: " + name);
    };

    @Test
    public void testBooleanSelector() throws Exception {
        MockMessage message = this.createMessage();
        this.assertSelector(message, "(${trueProp} || ${falseProp}) && ${trueProp}", true);
        this.assertSelector(message, "(${trueProp} || ${falseProp}) && ${falseProp}", false);
    }

    @Test
    public void testJMSPropertySelectors() throws Exception {
        MockMessage message = this.createMessage();
        message.setJMSType("selector-test");
        message.setJMSMessageID("id:test:1:1:1:1");
        this.assertSelector(message, "${JMSType} == 'selector-test'", true);
        this.assertSelector(message, "${JMSType} == 'crap'", false);
        this.assertSelector(message, "${JMSMessageID} == 'id:test:1:1:1:1'", true);
        this.assertSelector(message, "${JMSMessageID} == 'id:not-test:1:1:1:1'", false);
        message = this.createMessage();
        message.setJMSType("1001");
        this.assertSelector(message, "${JMSType}=='1001'", true);
        this.assertSelector(message, "${JMSType}=='1001' || ${JMSType}=='1002'", true);
        this.assertSelector(message, "${JMSType} == 'crap'", false);
    }

    @Test
    public void testBasicSelectors() throws Exception {
        MockMessage message = this.createMessage();
        this.assertSelector(message, "${name} == 'James'", true);
        this.assertSelector(message, "${rank} > 100", true);
        this.assertSelector(message, "${rank} >= 123", true);
        this.assertSelector(message, "${rank} >= 124", false);
    }

    @Test
    public void testPropertyTypes() throws Exception {
        MockMessage message = this.createMessage();
        this.assertSelector(message, "${byteProp} == 123", true);
        this.assertSelector(message, "${byteProp} == 10", false);
        this.assertSelector(message, "${byteProp2} == 33", true);
        this.assertSelector(message, "${byteProp2} == 10", false);
        this.assertSelector(message, "${shortProp} == 123", true);
        this.assertSelector(message, "${shortProp} == 10", false);
        this.assertSelector(message, "${shortProp} == 123", true);
        this.assertSelector(message, "${shortProp} == 10", false);
        this.assertSelector(message, "${intProp} == 123", true);
        this.assertSelector(message, "${intProp} == 10", false);
        this.assertSelector(message, "${longProp} == 123", true);
        this.assertSelector(message, "${longProp} == 10", false);
        this.assertSelector(message, "${floatProp} == 123", true);
        this.assertSelector(message, "${floatProp} == 10", false);
        this.assertSelector(message, "${doubleProp} == 123", true);
        this.assertSelector(message, "${doubleProp} == 10", false);
        this.assertSelector(message, "${bigIntegerProp} == 7", true);
        this.assertSelector(message, "${bigIntegerProp} == 1", false);
        this.assertSelector(message, "${bigIntegerProp} == 7.1", false);
        this.assertSelector(message, "${bigDecimalProp} == 7.7", true);
        this.assertSelector(message, "${bigDecimalProp} == 7.8", false);
        this.assertSelector(message, "${bigDecimalProp} == 7", false);
        this.assertSelector(message, "${bigDecimalProp} == 8", false);
    }

    @Test
    public void testAndSelectors() throws Exception {
        MockMessage message = this.createMessage();
        this.assertSelector(message, "${name} == 'James' && ${rank} < 200", true);
        this.assertSelector(message, "${name} == 'James' && ${rank} > 200", false);
        this.assertSelector(message, "${name} == 'Foo' && ${rank} < 200", false);
        this.assertSelector(message, "${unknown} == 'Foo' && ${anotherUnknown} < 200", false);
    }

    @Test
    public void testOrSelectors() throws Exception {
        MockMessage message = this.createMessage();
        this.assertSelector(message, "${name} == 'James' || ${rank} < 200", true);
        this.assertSelector(message, "${name} == 'James' || ${rank} > 200", true);
        this.assertSelector(message, "${name} == 'Foo' || ${rank} < 200", true);
        this.assertSelector(message, "${name} == 'Foo' || ${rank} > 200", false);
        this.assertSelector(message, "${unknown} == 'Foo' || ${anotherUnknown} < 200", null);
    }

    @Test
    public void testPlus() throws Exception {
        MockMessage message = this.createMessage();
        this.assertSelector(message, "${rank} + 2 == 125", true);
        this.assertSelector(message, "(${rank} + 2) == 125", true);
        this.assertSelector(message, "125 == (${rank} + 2)", true);
        this.assertSelector(message, "${rank} + ${version} == 125", true);
        this.assertSelector(message, "${rank} + 2 < 124", false);
        this.assertSelector(message, "${name} + '!' == 'James!'", true);
    }

    @Test
    public void testMinus() throws Exception {
        MockMessage message = this.createMessage();
        this.assertSelector(message, "${rank} - 2 == 121", true);
        this.assertSelector(message, "${rank} - ${version} == 121", true);
        this.assertSelector(message, "${rank} - 2 > 122", false);
    }

    @Test
    public void testMultiply() throws Exception {
        MockMessage message = this.createMessage();
        this.assertSelector(message, "${rank} * 2 == 246", true);
        this.assertSelector(message, "${rank} * ${version} == 246", true);
        this.assertSelector(message, "${rank} * 2 < 130", false);
    }

    @Test
    public void testDivide() throws Exception {
        MockMessage message = this.createMessage();
        this.assertSelector(message, "${rank} / ${version} == 61.5", true);
        this.assertSelector(message, "${rank} / 3 > 100.0", false);
        this.assertSelector(message, "${rank} / 3 > 100", false);
        this.assertSelector(message, "${version} / 2 == 1", true);
    }

    @Test
    public void testIsNull() throws Exception {
        MockMessage message = this.createMessage();
        this.assertSelector(message, "${dummy} == null", true);
        this.assertSelector(message, "${dummy} != null", false);
        this.assertSelector(message, "${name} != null", true);
        this.assertSelector(message, "${name} == null", false);
    }

    @Test
    public void testMatsHenricsonUseCases() throws Exception {
        MockMessage message = this.createMessage();
        this.assertSelector(message, "${SessionserverId}==1870414179", false);
        message.setLongProperty("SessionserverId", 1870414179L);
        this.assertSelector(message, "${SessionserverId}==1870414179", true);
        message.setLongProperty("SessionserverId", 1234L);
        this.assertSelector(message, "${SessionserverId}==1870414179", false);
    }

    @Test
    public void testFloatComparisons() throws Exception {
        MockMessage message = this.createMessage();
        double x = 1.0;
        x = -1.1;
        x = 10.0;
        x = 11.0;
        x = -11.0;
        this.assertSelector(message, "1.0 < 1.1", true);
        this.assertSelector(message, "-1.1 < 1.0", true);
        this.assertSelector(message, "1.0E1 < 1.1E1", true);
        this.assertSelector(message, "-1.1E1 < 1.0E1", true);
        x = 1.0;
        x = 10.0;
        this.assertSelector(message, "1. < 1.1", true);
        this.assertSelector(message, "-1.1 < 1.", true);
        this.assertSelector(message, "1.E1 < 1.1E1", true);
        this.assertSelector(message, "-1.1E1 < 1.E1", true);
        x = 0.5;
        x = -0.5;
        x = 5.0;
        this.assertSelector(message, ".1 < .5", true);
        this.assertSelector(message, "-.5 < .1", true);
        this.assertSelector(message, ".1E1 < .5E1", true);
        this.assertSelector(message, "-.5E1 < .1E1", true);
        x = 4.0E10;
        x = -4.0E10;
        x = 5.0E10;
        x = 5.0E-10;
        this.assertSelector(message, "4E10 < 5E10", true);
        this.assertSelector(message, "5E8 < 5E10", true);
        this.assertSelector(message, "-4E10 < 2E10", true);
        this.assertSelector(message, "-5E8 < 2E2", true);
        this.assertSelector(message, "4E+10 < 5E+10", true);
        this.assertSelector(message, "4E-10 < 5E-10", true);
    }

    @Test
    public void testStringQuoteParsing() throws Exception {
        MockMessage message = this.createMessage();
        this.assertSelector(message, "${quote} == '''In God We Trust'''", true);
    }

    @Test
    public void testToLowerFunction() throws Exception {
        MockMessage message = this.createMessage();
        this.assertSelector(message, "ToLower(${name})", "james");
    }

    @Test
    public void testIfFunction() throws Exception {
        MockMessage message = this.createMessage();
        this.assertSelector(message, "IF(.1 < .5, 'good', 'bad')", "good");
        this.assertSelector(message, "IF(.1 > .5, 'good', 'bad')", "bad");
    }

    @Test
    public void testNestedFunction() throws Exception {
        MockMessage message = this.createMessage();
        this.assertSelector(message, "IF(ToLower(${name}) == 'james', 'good', 'bad')", "good");
        this.assertSelector(message, "IF(ToLower(${name}) == 'James', 'good', 'bad')", "bad");
    }

    @Test
    public void testConcatenateAction() throws Exception {
        MockMessage message = this.createMessage();
        this.assertSelector(message, "concatenate('', ToLower(${name}), ${name})", "jamesJames");
    }

    @Test
    public void testConcatenateWithDelimiterAction() throws Exception {
        MockMessage message = this.createMessage();
        this.assertSelector(message, "concatenate(',', ToLower(${name}), ${name})", "james,James");
    }

    @Test
    public void testInvalidSelector() throws Exception {
        MockMessage message = this.createMessage();
        this.assertInvalidSelector(message, "True && 3+5");
        this.assertInvalidSelector(message, "=TEST 'test'");
    }

    protected MockMessage createMessage() {
        MockMessage message = this.createMessage("FOO.BAR");
        message.setJMSType("selector-test");
        message.setJMSMessageID("connection:1:1:1:1");
        message.setObjectProperty("name", "James");
        message.setObjectProperty("location", "London");
        message.setByteProperty("byteProp", (byte)123);
        message.setByteProperty("byteProp2", (byte)33);
        message.setShortProperty("shortProp", (short)123);
        message.setIntProperty("intProp", 123);
        message.setLongProperty("longProp", 123L);
        message.setFloatProperty("floatProp", 123.0f);
        message.setDoubleProperty("doubleProp", 123.0);
        message.setIntProperty("rank", 123);
        message.setIntProperty("version", 2);
        message.setStringProperty("quote", "'In God We Trust'");
        message.setStringProperty("foo", "_foo");
        message.setStringProperty("punctuation", "!#$&()*+,-./:;<=>?@[\\]^`{|}~");
        message.setBooleanProperty("trueProp", true);
        message.setBooleanProperty("falseProp", false);
        message.setBigIntegerProperty("bigIntegerProp", new BigInteger("7"));
        message.setBigDecimalProperty("bigDecimalProp", new BigDecimal("7.7"));
        return message;
    }

    protected void assertInvalidSelector(MockMessage message, String text) {
        try {
            Expression.parse((String)text, (FunctionResolver)FUNCTION_RESOLVER);
            Assertions.fail((String)"Created a valid selector");
        }
        catch (ExpressionException expressionException) {
            // empty catch block
        }
    }

    protected void assertSelector(MockMessage message, String text, Object expected) throws ExpressionException {
        Expression selector = null;
        selector = Expression.parse((String)text, (FunctionResolver)FUNCTION_RESOLVER);
        Assertions.assertTrue((selector != null ? 1 : 0) != 0, (String)"Created a valid selector");
        Object value = selector.evaluate((ExpressionContext)message).getValue();
        Assertions.assertEquals((Object)expected, (Object)value, (String)("Selector for: " + text));
    }

    protected MockMessage createMessage(String subject) {
        MockMessage message = new MockMessage();
        message.setDestination(subject);
        return message;
    }

    class MockMessage
    implements ExpressionContext {
        HashMap<String, Object> properties = new HashMap();
        private String text;
        private Object destination;
        private String messageId;
        private String type;
        private Object localConnectionId;

        MockMessage() {
        }

        public void setDestination(Object destination) {
            this.destination = destination;
        }

        public void setJMSMessageID(String messageId) {
            this.messageId = messageId;
        }

        public void setJMSType(String type) {
            this.type = type;
        }

        public void setText(String text) {
            this.text = text;
        }

        public void setBooleanProperty(String key, boolean value) {
            this.properties.put(key, value);
        }

        public void setStringProperty(String key, String value) {
            this.properties.put(key, value);
        }

        public void setByteProperty(String key, byte value) {
            this.properties.put(key, value);
        }

        public void setDoubleProperty(String key, double value) {
            this.properties.put(key, value);
        }

        public void setFloatProperty(String key, float value) {
            this.properties.put(key, Float.valueOf(value));
        }

        public void setLongProperty(String key, long value) {
            this.properties.put(key, value);
        }

        public void setIntProperty(String key, int value) {
            this.properties.put(key, value);
        }

        public void setShortProperty(String key, short value) {
            this.properties.put(key, value);
        }

        public void setObjectProperty(String key, Object value) {
            this.properties.put(key, value);
        }

        public void setBigIntegerProperty(String key, BigInteger value) {
            this.properties.put(key, value);
        }

        public void setBigDecimalProperty(String key, BigDecimal value) {
            this.properties.put(key, value);
        }

        public <T> T getBodyAs(Class<T> type) throws ExpressionException {
            if (type == String.class) {
                return type.cast(this.text);
            }
            return null;
        }

        public Field getVariable(String name) {
            if ("JMSType".equals(name)) {
                return AtlasModelFactory.wrapWithField((Object)this.type);
            }
            if ("JMSMessageID".equals(name)) {
                return AtlasModelFactory.wrapWithField((Object)this.messageId);
            }
            return AtlasModelFactory.wrapWithField((Object)this.properties.get(name));
        }

        public <T> T getDestination() {
            return (T)this.destination;
        }

        public Object getLocalConnectionId() {
            return this.localConnectionId;
        }
    }
}

