/*
 * Decompiled with CFR 0.152.
 */
package io.atlasmap.expression;

import io.atlasmap.expression.Expression;
import io.atlasmap.expression.internal.ComparisonExpression;
import io.atlasmap.expression.internal.LogicExpression;
import io.atlasmap.expression.internal.VariableExpression;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class ExpressionParserTest {
    @Test
    public void testParseWithParensAround() throws Exception {
        String[] values = new String[]{"${x} == 1 && ${y} == 2", "(${x} == 1) && (${y} == 2)", "((${x} == 1) && (${y} == 2))"};
        for (int i = 0; i < values.length; ++i) {
            String value = values[i];
            this.info("Parsing: " + value);
            Expression andExpression = this.parse(value);
            Assertions.assertTrue((boolean)(andExpression instanceof LogicExpression), (String)"Created LogicExpression expression");
            LogicExpression logicExpression = (LogicExpression)andExpression;
            Expression left = logicExpression.getLeft();
            Expression right = logicExpression.getRight();
            Assertions.assertTrue((boolean)(left instanceof ComparisonExpression), (String)"Left is a binary filter");
            Assertions.assertTrue((boolean)(right instanceof ComparisonExpression), (String)"Right is a binary filter");
            ComparisonExpression leftCompare = (ComparisonExpression)left;
            ComparisonExpression rightCompare = (ComparisonExpression)right;
            this.assertPropertyExpression("left", leftCompare.getLeft(), "x");
            this.assertPropertyExpression("right", rightCompare.getLeft(), "y");
        }
    }

    private void info(String s) {
        System.out.println(s);
    }

    protected void assertPropertyExpression(String message, Expression expression, String expected) {
        Assertions.assertTrue((boolean)(expression instanceof VariableExpression), (String)(message + ". Must be PropertyExpression"));
        VariableExpression propExp = (VariableExpression)expression;
        Assertions.assertEquals((Object)expected, (Object)propExp.getName(), (String)(message + ". Property name"));
    }

    protected Expression parse(String text) throws Exception {
        return Expression.parse((String)text, null);
    }
}

