/*
 * Decompiled with CFR 0.152.
 */
package io.atlasmap.expression;

import io.atlasmap.expression.Expression;
import io.atlasmap.expression.internal.ComparisonExpression;
import io.atlasmap.expression.internal.LogicExpression;
import io.atlasmap.expression.internal.VariableExpression;
import junit.framework.TestCase;

public class ExpressionParserTest
extends TestCase {
    public void testParseWithParensAround() throws Exception {
        String[] values = new String[]{"${x} == 1 && ${y} == 2", "(${x} == 1) && (${y} == 2)", "((${x} == 1) && (${y} == 2))"};
        for (int i = 0; i < values.length; ++i) {
            String value = values[i];
            this.info("Parsing: " + value);
            Expression andExpression = this.parse(value);
            ExpressionParserTest.assertTrue((String)"Created LogicExpression expression", (boolean)(andExpression instanceof LogicExpression));
            LogicExpression logicExpression = (LogicExpression)andExpression;
            Expression left = logicExpression.getLeft();
            Expression right = logicExpression.getRight();
            ExpressionParserTest.assertTrue((String)"Left is a binary filter", (boolean)(left instanceof ComparisonExpression));
            ExpressionParserTest.assertTrue((String)"Right is a binary filter", (boolean)(right instanceof ComparisonExpression));
            ComparisonExpression leftCompare = (ComparisonExpression)left;
            ComparisonExpression rightCompare = (ComparisonExpression)right;
            this.assertPropertyExpression("left", leftCompare.getLeft(), "x");
            this.assertPropertyExpression("right", rightCompare.getLeft(), "y");
        }
    }

    private void info(String s) {
        System.out.println(s);
    }

    protected void assertPropertyExpression(String message, Expression expression, String expected) {
        ExpressionParserTest.assertTrue((String)(message + ". Must be PropertyExpression"), (boolean)(expression instanceof VariableExpression));
        VariableExpression propExp = (VariableExpression)expression;
        ExpressionParserTest.assertEquals((String)(message + ". Property name"), (String)expected, (String)propExp.getName());
    }

    protected Expression parse(String text) throws Exception {
        return Expression.parse((String)text, null);
    }
}

