/*
 * Decompiled with CFR 0.152.
 */
package io.atlasmap.expression;

import io.atlasmap.expression.ExpressionContext;
import io.atlasmap.expression.ExpressionException;
import io.atlasmap.expression.FunctionResolver;
import io.atlasmap.expression.internal.LRUCache;
import io.atlasmap.expression.parser.ParseException;
import io.atlasmap.expression.parser.Parser;
import java.io.StringReader;

public interface Expression {
    public static final LRUCache cache = new LRUCache(100);

    public Object evaluate(ExpressionContext var1) throws ExpressionException;

    public static Expression parse(String expessionText, FunctionResolver functionResolver) throws ExpressionException {
        Object result;
        if (functionResolver == null) {
            functionResolver = (name, args) -> {
                throw new ParseException("Function not found: " + name);
            };
        }
        if ((result = cache.get(expessionText)) instanceof ExpressionException) {
            throw (ExpressionException)result;
        }
        if (result instanceof Expression) {
            return (Expression)result;
        }
        String actual = expessionText;
        try {
            Parser parser = new Parser(new StringReader(actual));
            parser.functionResolver = functionResolver;
            Expression e = parser.parse();
            cache.put(expessionText, e);
            return e;
        }
        catch (Throwable e) {
            ExpressionException fe = new ExpressionException(actual, e);
            cache.put(expessionText, fe);
            throw fe;
        }
    }

    public static void clearCache() {
        cache.clear();
    }
}

