/*
 * Decompiled with CFR 0.152.
 */
package io.atlasmap.dfdl.service;

import io.atlasmap.dfdl.core.schema.CsvDfdlSchemaGenerator;
import io.atlasmap.dfdl.service.DfdlService;
import io.atlasmap.dfdl.v2.DfdlInspectionRequest;
import io.atlasmap.dfdl.v2.DfdlInspectionResponse;
import io.atlasmap.v2.FieldType;
import io.atlasmap.v2.Json;
import io.atlasmap.xml.v2.InspectionType;
import io.atlasmap.xml.v2.XmlComplexType;
import io.atlasmap.xml.v2.XmlDocument;
import io.atlasmap.xml.v2.XmlField;
import javax.ws.rs.core.Response;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class DfdlServiceTest {
    private DfdlService dfdlService = null;

    @Before
    public void setUp() {
        this.dfdlService = new DfdlService();
    }

    @After
    public void tearDown() {
        this.dfdlService = null;
    }

    @Test
    public void testSchema() throws Exception {
        String source = "header1,header2,header3\nl1r1,l1r2,l1r3\nl2r1,l2r2,l2r3\nl3r1,l3r2,l3r3\n";
        DfdlInspectionRequest request = new DfdlInspectionRequest();
        request.setType(InspectionType.SCHEMA);
        request.setDfdlSchemaName("csv");
        request.getOptions().put(CsvDfdlSchemaGenerator.Options.HEADER.value(), "header1,header2,header3\nl1r1,l1r2,l1r3\nl2r1,l2r2,l2r3\nl3r1,l3r2,l3r3\n");
        request.getOptions().put(CsvDfdlSchemaGenerator.Options.DELIMITER.value(), ",");
        Response res = this.dfdlService.inspect(request);
        Object entity = res.getEntity();
        Assert.assertEquals(byte[].class, entity.getClass());
        DfdlInspectionResponse inspectionResponse = (DfdlInspectionResponse)Json.mapper().readValue((byte[])entity, DfdlInspectionResponse.class);
        XmlDocument xmlDoc = inspectionResponse.getXmlDocument();
        Assert.assertEquals((long)1L, (long)xmlDoc.getFields().getField().size());
        XmlComplexType file = (XmlComplexType)xmlDoc.getFields().getField().get(0);
        Assert.assertEquals((Object)"tns:file", (Object)file.getName());
        Assert.assertEquals((long)2L, (long)file.getXmlFields().getXmlField().size());
        XmlComplexType record = (XmlComplexType)file.getXmlFields().getXmlField().get(1);
        Assert.assertEquals((Object)"record", (Object)record.getName());
        Assert.assertEquals((long)3L, (long)record.getXmlFields().getXmlField().size());
        XmlField header1 = (XmlField)record.getXmlFields().getXmlField().get(0);
        Assert.assertEquals((Object)"header1", (Object)header1.getName());
        Assert.assertEquals((Object)FieldType.STRING, (Object)header1.getFieldType());
        XmlField header2 = (XmlField)record.getXmlFields().getXmlField().get(1);
        Assert.assertEquals((Object)"header2", (Object)header2.getName());
        Assert.assertEquals((Object)FieldType.STRING, (Object)header2.getFieldType());
        XmlField header3 = (XmlField)record.getXmlFields().getXmlField().get(2);
        Assert.assertEquals((Object)"header3", (Object)header3.getName());
        Assert.assertEquals((Object)FieldType.STRING, (Object)header3.getFieldType());
    }

    @Test
    public void testInstance() throws Exception {
        String source = "header1,header2,header3\nl1r1,l1r2,l1r3\nl2r1,l2r2,l2r3\nl3r1,l3r2,l3r3\n";
        DfdlInspectionRequest request = new DfdlInspectionRequest();
        request.setType(InspectionType.INSTANCE);
        request.setDfdlSchemaName("csv");
        request.getOptions().put(CsvDfdlSchemaGenerator.Options.EXAMPLE.value(), "header1,header2,header3\nl1r1,l1r2,l1r3\nl2r1,l2r2,l2r3\nl3r1,l3r2,l3r3\n");
        request.getOptions().put(CsvDfdlSchemaGenerator.Options.DELIMITER.value(), ",");
        Response res = this.dfdlService.inspect(request);
        Object entity = res.getEntity();
        Assert.assertEquals(byte[].class, entity.getClass());
        DfdlInspectionResponse inspectionResponse = (DfdlInspectionResponse)Json.mapper().readValue((byte[])entity, DfdlInspectionResponse.class);
        XmlDocument xmlDoc = inspectionResponse.getXmlDocument();
        Assert.assertEquals((long)1L, (long)xmlDoc.getFields().getField().size());
        XmlComplexType root = (XmlComplexType)xmlDoc.getFields().getField().get(0);
        Assert.assertNotNull((Object)root);
        Assert.assertEquals((long)1L, (long)xmlDoc.getFields().getField().size());
        XmlComplexType file = (XmlComplexType)xmlDoc.getFields().getField().get(0);
        Assert.assertEquals((Object)"atlas:file", (Object)file.getName());
        Assert.assertEquals((long)2L, (long)file.getXmlFields().getXmlField().size());
        XmlComplexType record = (XmlComplexType)file.getXmlFields().getXmlField().get(1);
        Assert.assertEquals((Object)"record", (Object)record.getName());
        Assert.assertEquals((long)3L, (long)record.getXmlFields().getXmlField().size());
        XmlField header1 = (XmlField)record.getXmlFields().getXmlField().get(0);
        Assert.assertEquals((Object)"header1", (Object)header1.getName());
        Assert.assertEquals((Object)FieldType.STRING, (Object)header1.getFieldType());
        XmlField header2 = (XmlField)record.getXmlFields().getXmlField().get(1);
        Assert.assertEquals((Object)"header2", (Object)header2.getName());
        Assert.assertEquals((Object)FieldType.STRING, (Object)header2.getFieldType());
        XmlField header3 = (XmlField)record.getXmlFields().getXmlField().get(2);
        Assert.assertEquals((Object)"header3", (Object)header3.getName());
        Assert.assertEquals((Object)FieldType.STRING, (Object)header3.getFieldType());
    }
}

