/*
 * Decompiled with CFR 0.152.
 */
package io.atlasmap.dfdl.service;

import com.fasterxml.jackson.core.JsonProcessingException;
import io.atlasmap.dfdl.inspect.DfdlInspectionService;
import io.atlasmap.dfdl.v2.DfdlInspectionRequest;
import io.atlasmap.dfdl.v2.DfdlInspectionResponse;
import io.atlasmap.service.AtlasService;
import io.atlasmap.v2.Json;
import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.media.Content;
import io.swagger.v3.oas.annotations.media.Schema;
import io.swagger.v3.oas.annotations.parameters.RequestBody;
import io.swagger.v3.oas.annotations.responses.ApiResponse;
import io.swagger.v3.oas.annotations.responses.ApiResponses;
import java.io.IOException;
import java.io.InputStream;
import javax.ws.rs.Consumes;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.WebApplicationException;
import javax.ws.rs.container.ResourceContext;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.Response;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Path(value="/dfdl/")
public class DfdlService {
    private static final Logger LOG = LoggerFactory.getLogger(DfdlService.class);
    @Context
    private ResourceContext resourceContext;

    protected byte[] toJson(Object value) {
        try {
            return Json.mapper().writeValueAsBytes(value);
        }
        catch (JsonProcessingException e) {
            throw new WebApplicationException((Throwable)e, Response.Status.INTERNAL_SERVER_ERROR);
        }
    }

    protected <T> T fromJson(InputStream value, Class<T> clazz) {
        try {
            return (T)Json.mapper().readValue(value, clazz);
        }
        catch (IOException e) {
            throw new WebApplicationException((Throwable)e, Response.Status.BAD_REQUEST);
        }
    }

    @GET
    @Path(value="/simple")
    @Produces(value={"text/plain"})
    @Operation(summary="Simple", description="Simple hello service")
    @ApiResponses(value={@ApiResponse(responseCode="200", content={@Content(schema=@Schema(implementation=String.class))}, description="Return a response")})
    public String simpleHelloWorld(@QueryParam(value="from") String from) {
        return "Got it! " + from;
    }

    @POST
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    @Path(value="/inspect")
    @Operation(summary="Inspect DFDL", description="Inspect a DFDL schema or instance and return a Document object")
    @RequestBody(description="DfdlInspectionRequest object", content={@Content(schema=@Schema(implementation=DfdlInspectionRequest.class))})
    @ApiResponses(value={@ApiResponse(responseCode="200", content={@Content(schema=@Schema(implementation=DfdlInspectionResponse.class))}, description="Return a Document object represented by XmlDocument")})
    public Response inspect(InputStream request) {
        return this.inspect(this.fromJson(request, DfdlInspectionRequest.class));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    public Response inspect(DfdlInspectionRequest request) {
        block10: {
            startTime = System.currentTimeMillis();
            response = new DfdlInspectionResponse();
            d = null;
            try {
                if (request.getType() == null) {
                    response.setErrorMessage("Instance or Schema type must be specified in request");
                    break block10;
                }
                loader = this.resourceContext != null ? ((AtlasService)this.resourceContext.getResource(AtlasService.class)).getLibraryLoader() : DfdlService.class.getClassLoader();
                s = new DfdlInspectionService(loader);
                switch (1.$SwitchMap$io$atlasmap$xml$v2$InspectionType[request.getType().ordinal()]) {
                    case 1: {
                        d = s.inspectDfdlInstance(request.getDfdlSchemaName(), request.getOptions());
                        ** break;
lbl14:
                        // 1 sources

                        break;
                    }
                    case 2: {
                        d = s.inspectDfdlSchema(request.getDfdlSchemaName(), request.getOptions());
                        ** break;
lbl18:
                        // 1 sources

                        break;
                    }
                    default: {
                        response.setErrorMessage("Unsupported inspection type: " + request.getType());
                        break;
                    }
                }
            }
            catch (Exception e) {
                DfdlService.LOG.error("Error inspecting DFDL: " + e.getMessage(), (Throwable)e);
                response.setErrorMessage(e.getMessage());
            }
            finally {
                response.setExecutionTime(Long.valueOf(System.currentTimeMillis() - startTime));
            }
        }
        response.setXmlDocument(d);
        return Response.ok().entity((Object)this.toJson(response)).build();
    }
}

