/*
 * Decompiled with CFR 0.152.
 */
package io.astefanutti.metrics.aspectj.se;

import com.codahale.metrics.MetricRegistry;
import com.codahale.metrics.SharedMetricRegistries;
import io.astefanutti.metrics.aspectj.se.TimedStaticMethodWithVisibilityModifiers;
import io.astefanutti.metrics.aspectj.se.util.MetricsUtil;
import java.util.Set;
import org.fest.reflect.core.Reflection;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.junit.Assert;
import org.junit.Test;

public class TimedStaticMethodWithVisibilityModifiersTest {
    private static final String REGISTRY_NAME = "visibilityTimerStaticRegistry";
    private static final String[] TIMER_NAMES = new String[]{"publicTimedStaticMethod", "packagePrivateTimedStaticMethod", "protectedTimedStaticMethod", "privateTimedStaticMethod"};

    private static Set<String> absoluteMetricNames() {
        return MetricsUtil.absoluteMetricNames(TimedStaticMethodWithVisibilityModifiers.class, TIMER_NAMES);
    }

    @Test
    public void callTimedStaticMethodsOnce() {
        TimedStaticMethodWithVisibilityModifiers.publicTimedStaticMethod();
        TimedStaticMethodWithVisibilityModifiers.protectedTimedStaticMethod();
        TimedStaticMethodWithVisibilityModifiers.packagePrivateTimedStaticMethod();
        Reflection.staticMethod((String)"privateTimedStaticMethod").in(TimedStaticMethodWithVisibilityModifiers.class).invoke(new Object[0]);
        Assert.assertThat((String)"Shared metric registry is not created", (Object)SharedMetricRegistries.names(), (Matcher)Matchers.hasItem((Object)REGISTRY_NAME));
        MetricRegistry registry = SharedMetricRegistries.getOrCreate((String)REGISTRY_NAME);
        Assert.assertThat((String)"Timers are not registered correctly", registry.getTimers().keySet(), (Matcher)Matchers.is((Matcher)Matchers.equalTo(TimedStaticMethodWithVisibilityModifiersTest.absoluteMetricNames())));
        Assert.assertThat((String)"Timer counts are incorrect", registry.getTimers().values(), (Matcher)Matchers.everyItem((Matcher)Matchers.hasProperty((String)"count", (Matcher)Matchers.equalTo((Object)1L))));
    }
}

