/*
 * Decompiled with CFR 0.152.
 */
package io.astefanutti.metrics.aspectj.se;

import com.codahale.metrics.MetricRegistry;
import com.codahale.metrics.SharedMetricRegistries;
import io.astefanutti.metrics.aspectj.se.TimedMethodWithVisibilityModifiers;
import io.astefanutti.metrics.aspectj.se.util.MetricsUtil;
import java.util.Set;
import org.fest.reflect.core.Reflection;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class TimedMethodWithVisibilityModifiersTest {
    private static final String REGISTRY_NAME = "visibilityTimerRegistry";
    private static final String[] TIMER_NAMES = new String[]{"publicTimedMethod", "packagePrivateTimedMethod", "protectedTimedMethod", "privateTimedMethod"};
    private TimedMethodWithVisibilityModifiers instance;

    private Set<String> absoluteMetricNames() {
        return MetricsUtil.absoluteMetricNames(TimedMethodWithVisibilityModifiers.class, TIMER_NAMES);
    }

    @Before
    public void createTimedInstance() {
        this.instance = new TimedMethodWithVisibilityModifiers();
    }

    @After
    public void clearSharedMetricRegistries() {
        SharedMetricRegistries.clear();
    }

    @Test
    public void timedMethodsNotCalledYet() {
        Assert.assertThat((String)"Shared metric registry is not created", (Object)SharedMetricRegistries.names(), (Matcher)Matchers.hasItem((Object)REGISTRY_NAME));
        MetricRegistry registry = SharedMetricRegistries.getOrCreate((String)REGISTRY_NAME);
        Assert.assertThat((String)"Timers are not registered correctly", registry.getTimers().keySet(), (Matcher)Matchers.is((Matcher)Matchers.equalTo(this.absoluteMetricNames())));
        Assert.assertThat((String)"Timer counts are incorrect", registry.getTimers().values(), (Matcher)Matchers.everyItem((Matcher)Matchers.hasProperty((String)"count", (Matcher)Matchers.equalTo((Object)0L))));
    }

    @Test
    public void callTimedMethodsOnce() {
        Assert.assertThat((String)"Shared metric registry is not created", (Object)SharedMetricRegistries.names(), (Matcher)Matchers.hasItem((Object)REGISTRY_NAME));
        MetricRegistry registry = SharedMetricRegistries.getOrCreate((String)REGISTRY_NAME);
        Assert.assertThat((String)"Timers are not registered correctly", registry.getTimers().keySet(), (Matcher)Matchers.is((Matcher)Matchers.equalTo(this.absoluteMetricNames())));
        this.instance.publicTimedMethod();
        this.instance.protectedTimedMethod();
        this.instance.packagePrivateTimedMethod();
        Reflection.method((String)"privateTimedMethod").in((Object)this.instance).invoke(new Object[0]);
        Assert.assertThat((String)"Timer counts are incorrect", registry.getTimers().values(), (Matcher)Matchers.everyItem((Matcher)Matchers.hasProperty((String)"count", (Matcher)Matchers.equalTo((Object)1L))));
    }
}

