/*
 * Decompiled with CFR 0.152.
 */
package io.astefanutti.metrics.aspectj.se;

import com.codahale.metrics.MetricRegistry;
import com.codahale.metrics.SharedMetricRegistries;
import com.codahale.metrics.Timer;
import io.astefanutti.metrics.aspectj.se.TimedMethodWithAbsoluteName;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class TimedMethodWithAbsoluteNameTest {
    private static final String REGISTRY_NAME = "timerRegistryForAbsoluteNamedTimer";
    private static final String TIMER_NAME = "absoluteTimedMethod";
    private TimedMethodWithAbsoluteName instance;

    @Before
    public void createTimedInstance() {
        this.instance = new TimedMethodWithAbsoluteName();
    }

    @After
    public void clearSharedMetricRegistries() {
        SharedMetricRegistries.clear();
    }

    @Test
    public void timedMethodNotCalledYet() {
        Assert.assertThat((String)"Shared metric registry is not created", (Object)SharedMetricRegistries.names(), (Matcher)Matchers.hasItem((Object)REGISTRY_NAME));
        MetricRegistry registry = SharedMetricRegistries.getOrCreate((String)REGISTRY_NAME);
        Assert.assertThat((String)"Timer is not registered correctly", (Object)registry.getTimers(), (Matcher)Matchers.hasKey((Object)TIMER_NAME));
        Timer timer = (Timer)registry.getTimers().get(TIMER_NAME);
        Assert.assertThat((String)"Timer count is incorrect", (Object)timer.getCount(), (Matcher)Matchers.is((Matcher)Matchers.equalTo((Object)0L)));
    }

    @Test
    public void callTimedMethodOnce() {
        Assert.assertThat((String)"Shared metric registry is not created", (Object)SharedMetricRegistries.names(), (Matcher)Matchers.hasItem((Object)REGISTRY_NAME));
        MetricRegistry registry = SharedMetricRegistries.getOrCreate((String)REGISTRY_NAME);
        Assert.assertThat((String)"Timer is not registered correctly", (Object)registry.getTimers(), (Matcher)Matchers.hasKey((Object)TIMER_NAME));
        Timer timer = (Timer)registry.getTimers().get(TIMER_NAME);
        this.instance.absoluteTimedMethod();
        Assert.assertThat((String)"Timer count is incorrect", (Object)timer.getCount(), (Matcher)Matchers.is((Matcher)Matchers.equalTo((Object)1L)));
    }
}

