/*
 * Decompiled with CFR 0.152.
 */
package io.astefanutti.metrics.aspectj.se;

import com.codahale.metrics.MetricRegistry;
import com.codahale.metrics.SharedMetricRegistries;
import io.astefanutti.metrics.aspectj.se.TimedMethodOverloaded;
import io.astefanutti.metrics.aspectj.se.util.MetricsUtil;
import java.util.Arrays;
import java.util.Set;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class TimedMethodOverloadedTest {
    private static final String REGISTRY_NAME = "overloadedTimerRegistry";
    private static final String[] TIMER_NAMES = new String[]{"overloadedTimedMethodWithNoArguments", "overloadedTimedMethodWithStringArgument", "overloadedTimedMethodWithListOfStringArgument", "overloadedTimedMethodWithObjectArgument"};
    private TimedMethodOverloaded instance;

    private Set<String> absoluteMetricNames() {
        return MetricsUtil.absoluteMetricNames(TimedMethodOverloaded.class, TIMER_NAMES);
    }

    @Before
    public void createTimedInstance() {
        this.instance = new TimedMethodOverloaded();
    }

    @After
    public void clearSharedMetricRegistries() {
        SharedMetricRegistries.clear();
    }

    @Test
    public void overloadedTimedMethodNotCalledYet() {
        Assert.assertThat((String)"Shared metric registry is not created", (Object)SharedMetricRegistries.names(), (Matcher)Matchers.hasItem((Object)REGISTRY_NAME));
        MetricRegistry registry = SharedMetricRegistries.getOrCreate((String)REGISTRY_NAME);
        Assert.assertThat((String)"Timers are not registered correctly", registry.getTimers().keySet(), (Matcher)Matchers.is((Matcher)Matchers.equalTo(this.absoluteMetricNames())));
        Assert.assertThat((String)"Timer counts are incorrect", registry.getTimers().values(), (Matcher)Matchers.everyItem((Matcher)Matchers.hasProperty((String)"count", (Matcher)Matchers.equalTo((Object)0L))));
    }

    @Test
    public void callOverloadedTimedMethodOnce() {
        Assert.assertThat((String)"Shared metric registry is not created", (Object)SharedMetricRegistries.names(), (Matcher)Matchers.hasItem((Object)REGISTRY_NAME));
        MetricRegistry registry = SharedMetricRegistries.getOrCreate((String)REGISTRY_NAME);
        Assert.assertThat((String)"Timers are not registered correctly", registry.getTimers().keySet(), (Matcher)Matchers.is((Matcher)Matchers.equalTo(this.absoluteMetricNames())));
        this.instance.overloadedTimedMethod();
        this.instance.overloadedTimedMethod("string");
        this.instance.overloadedTimedMethod(new Object());
        this.instance.overloadedTimedMethod(Arrays.asList("string1", "string2"));
        Assert.assertThat((String)"Timer counts are incorrect", registry.getTimers().values(), (Matcher)Matchers.everyItem((Matcher)Matchers.hasProperty((String)"count", (Matcher)Matchers.equalTo((Object)1L))));
    }
}

