/*
 * Decompiled with CFR 0.152.
 */
package io.astefanutti.metrics.aspectj.se;

import com.codahale.metrics.Gauge;
import com.codahale.metrics.Meter;
import com.codahale.metrics.MetricRegistry;
import com.codahale.metrics.SharedMetricRegistries;
import com.codahale.metrics.Timer;
import io.astefanutti.metrics.aspectj.se.MultipleMetricsMethod;
import io.astefanutti.metrics.aspectj.se.util.MetricsUtil;
import java.util.Set;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class MultipleMetricsMethodTest {
    private static final String REGISTRY_NAME = "multipleMetricsRegistry";
    private static final String[] METRIC_NAMES = new String[]{"exception", "gauge", "meter", "timer"};
    private MultipleMetricsMethod instance;

    private Set<String> absoluteMetricNames() {
        return MetricsUtil.absoluteMetricNames(MultipleMetricsMethod.class, METRIC_NAMES);
    }

    private String absoluteMetricName(String name) {
        return MetricsUtil.absoluteMetricName(MultipleMetricsMethod.class, name);
    }

    @Before
    public void createInstance() {
        this.instance = new MultipleMetricsMethod();
    }

    @After
    public void clearSharedMetricRegistries() {
        SharedMetricRegistries.clear();
    }

    @Test
    public void metricsMethodNotCalledYet() {
        Assert.assertThat((String)"Shared metric registry is not created", (Object)SharedMetricRegistries.names(), (Matcher)Matchers.hasItem((Object)REGISTRY_NAME));
        MetricRegistry registry = SharedMetricRegistries.getOrCreate((String)REGISTRY_NAME);
        Assert.assertThat((String)"Metrics are not registered correctly", registry.getMetrics().keySet(), (Matcher)Matchers.is((Matcher)Matchers.equalTo(this.absoluteMetricNames())));
        Assert.assertThat((String)"Meter count is incorrect", (Object)((Meter)registry.getMeters().get(this.absoluteMetricName("exception"))).getCount(), (Matcher)Matchers.is((Matcher)Matchers.equalTo((Object)0L)));
        Assert.assertThat((String)"Meter count is incorrect", (Object)((Meter)registry.getMeters().get(this.absoluteMetricName("meter"))).getCount(), (Matcher)Matchers.is((Matcher)Matchers.equalTo((Object)0L)));
        Assert.assertThat((String)"Timer count is incorrect", (Object)((Timer)registry.getTimers().get(this.absoluteMetricName("timer"))).getCount(), (Matcher)Matchers.is((Matcher)Matchers.equalTo((Object)0L)));
    }

    @Test
    public void callMetricsMethodOnce() {
        Assert.assertThat((String)"Shared metric registry is not created", (Object)SharedMetricRegistries.names(), (Matcher)Matchers.hasItem((Object)REGISTRY_NAME));
        MetricRegistry registry = SharedMetricRegistries.getOrCreate((String)REGISTRY_NAME);
        Assert.assertThat((String)"Metrics are not registered correctly", registry.getMetrics().keySet(), (Matcher)Matchers.is((Matcher)Matchers.equalTo(this.absoluteMetricNames())));
        this.instance.metricsMethod();
        Assert.assertThat((String)"Meter count is incorrect", (Object)((Meter)registry.getMeters().get(this.absoluteMetricName("exception"))).getCount(), (Matcher)Matchers.is((Matcher)Matchers.equalTo((Object)0L)));
        Assert.assertThat((String)"Meter count is incorrect", (Object)((Meter)registry.getMeters().get(this.absoluteMetricName("meter"))).getCount(), (Matcher)Matchers.is((Matcher)Matchers.equalTo((Object)1L)));
        Assert.assertThat((String)"Timer count is incorrect", (Object)((Timer)registry.getTimers().get(this.absoluteMetricName("timer"))).getCount(), (Matcher)Matchers.is((Matcher)Matchers.equalTo((Object)1L)));
        Assert.assertThat((String)"Gauge value is incorrect", (Object)((Gauge)registry.getGauges().get(this.absoluteMetricName("gauge"))).getValue(), (Matcher)Matchers.hasToString((Matcher)Matchers.equalTo((Object)"value")));
    }
}

