/*
 * Decompiled with CFR 0.152.
 */
package io.astefanutti.metrics.aspectj.se;

import com.codahale.metrics.MetricRegistry;
import com.codahale.metrics.SharedMetricRegistries;
import io.astefanutti.metrics.aspectj.se.MetricMethodWithDefaultNames;
import io.astefanutti.metrics.aspectj.se.util.MetricsUtil;
import java.util.Arrays;
import java.util.Set;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class MetricMethodWithDefaultNamesTest {
    private static final String REGISTRY_NAME = "defaultNameRegistry";
    private static final String[] METRIC_NAMES = new String[]{"defaultNameTimedMethod", "defaultNameMeteredMethod", "defaultNameExceptionMeteredMethod.exceptions"};
    private static final String[] ABSOLUTE_METRIC_NAMES = new String[]{"absoluteDefaultNameTimedMethod", "absoluteDefaultNameMeteredMethod", "absoluteDefaultNameExceptionMeteredMethod.exceptions"};
    private MetricMethodWithDefaultNames instance;

    private Set<String> metricNames() {
        Set<String> names = MetricsUtil.absoluteMetricNames(MetricMethodWithDefaultNames.class, METRIC_NAMES);
        names.addAll(Arrays.asList(ABSOLUTE_METRIC_NAMES));
        return names;
    }

    @Before
    public void createMetricInstance() {
        this.instance = new MetricMethodWithDefaultNames();
    }

    @After
    public void clearSharedMetricRegistries() {
        SharedMetricRegistries.clear();
    }

    @Test
    public void metricMethodsWithDefaultNamingConvention() {
        Assert.assertThat((String)"Shared metric registry is not created", (Object)SharedMetricRegistries.names(), (Matcher)Matchers.hasItem((Object)REGISTRY_NAME));
        MetricRegistry registry = SharedMetricRegistries.getOrCreate((String)REGISTRY_NAME);
        Assert.assertThat((String)"Metrics are not registered correctly", registry.getMetrics().keySet(), (Matcher)Matchers.is((Matcher)Matchers.equalTo(this.metricNames())));
    }
}

