/*
 * Decompiled with CFR 0.152.
 */
package io.astefanutti.metrics.aspectj.se;

import com.codahale.metrics.Meter;
import com.codahale.metrics.MetricRegistry;
import com.codahale.metrics.SharedMetricRegistries;
import io.astefanutti.metrics.aspectj.se.MeteredStaticMethodWithExceptions;
import io.astefanutti.metrics.aspectj.se.util.MetricsUtil;
import java.util.Set;
import java.util.concurrent.atomic.AtomicLong;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.junit.Assert;
import org.junit.Test;

public class MeteredStaticMethodWithExceptionsTest {
    private static final String REGISTRY_NAME = "exceptionMeterStaticRegistry";
    private static final String[] METER_NAMES = new String[]{"illegalArgumentExceptionMeteredStaticMethod", "exceptionMeteredStaticMethod"};
    private static final AtomicLong[] METER_COUNTS = new AtomicLong[]{new AtomicLong(), new AtomicLong()};

    private static Set<String> absoluteMetricNames() {
        return MetricsUtil.absoluteMetricNames(MeteredStaticMethodWithExceptions.class, METER_NAMES);
    }

    private static String absoluteMetricName(int index) {
        return MetricsUtil.absoluteMetricName(MeteredStaticMethodWithExceptions.class, METER_NAMES[index]);
    }

    @Test
    public void callExceptionMeteredStaticMethodsOnceWithoutThrowing() {
        Runnable runnableThatDoesNoThrowExceptions = new Runnable(){

            @Override
            public void run() {
            }
        };
        MeteredStaticMethodWithExceptions.illegalArgumentExceptionMeteredStaticMethod((Runnable)runnableThatDoesNoThrowExceptions);
        MeteredStaticMethodWithExceptions.exceptionMeteredStaticMethod((Runnable)runnableThatDoesNoThrowExceptions);
        Assert.assertThat((String)"Shared metric registry is not created", (Object)SharedMetricRegistries.names(), (Matcher)Matchers.hasItem((Object)REGISTRY_NAME));
        MetricRegistry registry = SharedMetricRegistries.getOrCreate((String)REGISTRY_NAME);
        Assert.assertThat((String)"Meters are not registered correctly", registry.getMeters().keySet(), (Matcher)Matchers.is((Matcher)Matchers.equalTo(MeteredStaticMethodWithExceptionsTest.absoluteMetricNames())));
        Assert.assertThat((String)"Meter count is incorrect", (Object)((Meter)registry.getMeters().get(MeteredStaticMethodWithExceptionsTest.absoluteMetricName(0))).getCount(), (Matcher)Matchers.is((Matcher)Matchers.equalTo((Object)METER_COUNTS[0].get())));
        Assert.assertThat((String)"Meter count is incorrect", (Object)((Meter)registry.getMeters().get(MeteredStaticMethodWithExceptionsTest.absoluteMetricName(1))).getCount(), (Matcher)Matchers.is((Matcher)Matchers.equalTo((Object)METER_COUNTS[1].get())));
    }

    @Test
    public void callExceptionMeteredStaticMethodOnceWithThrowingExpectedException() {
        final IllegalArgumentException exception = new IllegalArgumentException("message");
        Runnable runnableThatThrowsIllegalArgumentException = new Runnable(){

            @Override
            public void run() {
                throw exception;
            }
        };
        try {
            MeteredStaticMethodWithExceptions.illegalArgumentExceptionMeteredStaticMethod((Runnable)runnableThatThrowsIllegalArgumentException);
        }
        catch (RuntimeException cause) {
            Assert.assertThat((String)"Shared metric registry is not created", (Object)SharedMetricRegistries.names(), (Matcher)Matchers.hasItem((Object)REGISTRY_NAME));
            MetricRegistry registry = SharedMetricRegistries.getOrCreate((String)REGISTRY_NAME);
            Assert.assertThat((String)"Meters are not registered correctly", registry.getMeters().keySet(), (Matcher)Matchers.is((Matcher)Matchers.equalTo(MeteredStaticMethodWithExceptionsTest.absoluteMetricNames())));
            Assert.assertThat((String)"Meter count is incorrect", (Object)((Meter)registry.getMeters().get(MeteredStaticMethodWithExceptionsTest.absoluteMetricName(0))).getCount(), (Matcher)Matchers.is((Matcher)Matchers.equalTo((Object)METER_COUNTS[0].incrementAndGet())));
            Assert.assertThat((String)"Meter count is incorrect", (Object)((Meter)registry.getMeters().get(MeteredStaticMethodWithExceptionsTest.absoluteMetricName(1))).getCount(), (Matcher)Matchers.is((Matcher)Matchers.equalTo((Object)METER_COUNTS[1].get())));
            Assert.assertSame((String)"Exception thrown is incorrect", (Object)cause, (Object)exception);
            return;
        }
        Assert.fail((String)"No exception has been re-thrown!");
    }

    @Test
    public void callExceptionMeteredStaticMethodOnceWithThrowingNonExpectedException() {
        final IllegalStateException exception = new IllegalStateException("message");
        Runnable runnableThatThrowsIllegalStateException = new Runnable(){

            @Override
            public void run() {
                throw exception;
            }
        };
        try {
            MeteredStaticMethodWithExceptions.illegalArgumentExceptionMeteredStaticMethod((Runnable)runnableThatThrowsIllegalStateException);
        }
        catch (RuntimeException cause) {
            Assert.assertThat((String)"Shared metric registry is not created", (Object)SharedMetricRegistries.names(), (Matcher)Matchers.hasItem((Object)REGISTRY_NAME));
            MetricRegistry registry = SharedMetricRegistries.getOrCreate((String)REGISTRY_NAME);
            Assert.assertThat((String)"Meters are not registered correctly", registry.getMeters().keySet(), (Matcher)Matchers.is((Matcher)Matchers.equalTo(MeteredStaticMethodWithExceptionsTest.absoluteMetricNames())));
            Assert.assertThat((String)"Meter count is incorrect", (Object)((Meter)registry.getMeters().get(MeteredStaticMethodWithExceptionsTest.absoluteMetricName(0))).getCount(), (Matcher)Matchers.is((Matcher)Matchers.equalTo((Object)METER_COUNTS[0].get())));
            Assert.assertThat((String)"Meter count is incorrect", (Object)((Meter)registry.getMeters().get(MeteredStaticMethodWithExceptionsTest.absoluteMetricName(1))).getCount(), (Matcher)Matchers.is((Matcher)Matchers.equalTo((Object)METER_COUNTS[1].get())));
            Assert.assertSame((String)"Exception thrown is incorrect", (Object)cause, (Object)exception);
            return;
        }
        Assert.fail((String)"No exception has been re-thrown!");
    }

    @Test
    public void callExceptionMeteredStaticMethodOnceWithThrowingInstanceOfExpectedException() {
        final IllegalStateException exception = new IllegalStateException("message");
        Runnable runnableThatThrowsIllegalStateException = new Runnable(){

            @Override
            public void run() {
                throw exception;
            }
        };
        try {
            MeteredStaticMethodWithExceptions.exceptionMeteredStaticMethod((Runnable)runnableThatThrowsIllegalStateException);
        }
        catch (RuntimeException cause) {
            Assert.assertThat((String)"Shared metric registry is not created", (Object)SharedMetricRegistries.names(), (Matcher)Matchers.hasItem((Object)REGISTRY_NAME));
            MetricRegistry registry = SharedMetricRegistries.getOrCreate((String)REGISTRY_NAME);
            Assert.assertThat((String)"Meters are not registered correctly", registry.getMeters().keySet(), (Matcher)Matchers.is((Matcher)Matchers.equalTo(MeteredStaticMethodWithExceptionsTest.absoluteMetricNames())));
            Assert.assertThat((String)"Meter count is incorrect", (Object)((Meter)registry.getMeters().get(MeteredStaticMethodWithExceptionsTest.absoluteMetricName(0))).getCount(), (Matcher)Matchers.is((Matcher)Matchers.equalTo((Object)METER_COUNTS[0].get())));
            Assert.assertThat((String)"Meter count is incorrect", (Object)((Meter)registry.getMeters().get(MeteredStaticMethodWithExceptionsTest.absoluteMetricName(1))).getCount(), (Matcher)Matchers.is((Matcher)Matchers.equalTo((Object)METER_COUNTS[1].incrementAndGet())));
            Assert.assertSame((String)"Exception thrown is incorrect", (Object)cause, (Object)exception);
            return;
        }
        Assert.fail((String)"No exception has been re-thrown!");
    }
}

