/*
 * Decompiled with CFR 0.152.
 */
package io.astefanutti.metrics.aspectj.se;

import com.codahale.metrics.Meter;
import com.codahale.metrics.MetricRegistry;
import com.codahale.metrics.SharedMetricRegistries;
import io.astefanutti.metrics.aspectj.se.MeteredMethodWithRegistryFromString;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class MeteredMethodWithRegistryFromStringTest {
    private static final String REGISTRY_NAME = "singleMeterRegistry";
    private static final String METER_NAME = MetricRegistry.name(MeteredMethodWithRegistryFromString.class, (String[])new String[]{"singleMeteredMethod"});
    private MeteredMethodWithRegistryFromString instance;

    @Before
    public void createMeteredInstance() {
        this.instance = new MeteredMethodWithRegistryFromString();
    }

    @After
    public void clearSharedMetricRegistries() {
        SharedMetricRegistries.clear();
    }

    @Test
    public void meteredMethodNotCalledYet() {
        Assert.assertThat((String)"Shared metric registry is not created", (Object)SharedMetricRegistries.names(), (Matcher)Matchers.hasItem((Object)REGISTRY_NAME));
        MetricRegistry registry = SharedMetricRegistries.getOrCreate((String)REGISTRY_NAME);
        Assert.assertThat((String)"Meter is not registered correctly", (Object)registry.getMeters(), (Matcher)Matchers.hasKey((Object)METER_NAME));
        Meter meter = (Meter)registry.getMeters().get(METER_NAME);
        Assert.assertThat((String)"Meter count is incorrect", (Object)meter.getCount(), (Matcher)Matchers.is((Matcher)Matchers.equalTo((Object)0L)));
    }

    @Test
    public void callMeteredMethodOnce() {
        Assert.assertThat((String)"Shared metric registry is not created", (Object)SharedMetricRegistries.names(), (Matcher)Matchers.hasItem((Object)REGISTRY_NAME));
        MetricRegistry registry = SharedMetricRegistries.getOrCreate((String)REGISTRY_NAME);
        Assert.assertThat((String)"Meter is not registered correctly", (Object)registry.getMeters(), (Matcher)Matchers.hasKey((Object)METER_NAME));
        Meter meter = (Meter)registry.getMeters().get(METER_NAME);
        this.instance.singleMeteredMethod();
        Assert.assertThat((String)"Meter count is incorrect", (Object)meter.getCount(), (Matcher)Matchers.is((Matcher)Matchers.equalTo((Object)1L)));
    }
}

