/*
 * Decompiled with CFR 0.152.
 */
package io.astefanutti.metrics.aspectj.se;

import com.codahale.metrics.Meter;
import com.codahale.metrics.MetricRegistry;
import com.codahale.metrics.SharedMetricRegistries;
import io.astefanutti.metrics.aspectj.se.MeteredMethodWithExceptions;
import io.astefanutti.metrics.aspectj.se.util.MetricsUtil;
import java.util.Set;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class MeteredMethodWithExceptionsTest {
    private static final String REGISTRY_NAME = "exceptionMeterRegistry";
    private static final String[] METER_NAMES = new String[]{"illegalArgumentExceptionMeteredMethod", "exceptionMeteredMethod"};
    private MeteredMethodWithExceptions instance;

    private Set<String> absoluteMetricNames() {
        return MetricsUtil.absoluteMetricNames(MeteredMethodWithExceptions.class, METER_NAMES);
    }

    private String absoluteMetricName(int index) {
        return MetricsUtil.absoluteMetricName(MeteredMethodWithExceptions.class, METER_NAMES[index]);
    }

    @Before
    public void createExceptionMeteredInstance() {
        this.instance = new MeteredMethodWithExceptions();
    }

    @After
    public void clearSharedMetricRegistries() {
        SharedMetricRegistries.clear();
    }

    @Test
    public void exceptionMeteredMethodsNotCalledYet() {
        Assert.assertThat((String)"Shared metric registry is not created", (Object)SharedMetricRegistries.names(), (Matcher)Matchers.hasItem((Object)REGISTRY_NAME));
        MetricRegistry registry = SharedMetricRegistries.getOrCreate((String)REGISTRY_NAME);
        Assert.assertThat((String)"Meters are not registered correctly", registry.getMeters().keySet(), (Matcher)Matchers.is((Matcher)Matchers.equalTo(this.absoluteMetricNames())));
        Assert.assertThat((String)"Meter counts are incorrect", registry.getMeters().values(), (Matcher)Matchers.everyItem((Matcher)Matchers.hasProperty((String)"count", (Matcher)Matchers.equalTo((Object)0L))));
    }

    @Test
    public void callExceptionMeteredMethodsOnceWithoutThrowing() {
        Assert.assertThat((String)"Shared metric registry is not created", (Object)SharedMetricRegistries.names(), (Matcher)Matchers.hasItem((Object)REGISTRY_NAME));
        MetricRegistry registry = SharedMetricRegistries.getOrCreate((String)REGISTRY_NAME);
        Assert.assertThat((String)"Meters are not registered correctly", registry.getMeters().keySet(), (Matcher)Matchers.is((Matcher)Matchers.equalTo(this.absoluteMetricNames())));
        Runnable runnableThatDoesNoThrowExceptions = new Runnable(){

            @Override
            public void run() {
            }
        };
        this.instance.illegalArgumentExceptionMeteredMethod(runnableThatDoesNoThrowExceptions);
        this.instance.exceptionMeteredMethod(runnableThatDoesNoThrowExceptions);
        Assert.assertThat((String)"Meter counts are incorrect", registry.getMeters().values(), (Matcher)Matchers.everyItem((Matcher)Matchers.hasProperty((String)"count", (Matcher)Matchers.equalTo((Object)0L))));
    }

    @Test
    public void callExceptionMeteredMethodOnceWithThrowingExpectedException() {
        Assert.assertThat((String)"Shared metric registry is not created", (Object)SharedMetricRegistries.names(), (Matcher)Matchers.hasItem((Object)REGISTRY_NAME));
        MetricRegistry registry = SharedMetricRegistries.getOrCreate((String)REGISTRY_NAME);
        Assert.assertThat((String)"Meters are not registered correctly", registry.getMeters().keySet(), (Matcher)Matchers.is((Matcher)Matchers.equalTo(this.absoluteMetricNames())));
        final IllegalArgumentException exception = new IllegalArgumentException("message");
        Runnable runnableThatThrowsIllegalArgumentException = new Runnable(){

            @Override
            public void run() {
                throw exception;
            }
        };
        try {
            this.instance.illegalArgumentExceptionMeteredMethod(runnableThatThrowsIllegalArgumentException);
        }
        catch (RuntimeException cause) {
            Assert.assertThat((String)"Meter count is incorrect", (Object)((Meter)registry.getMeters().get(this.absoluteMetricName(0))).getCount(), (Matcher)Matchers.is((Matcher)Matchers.equalTo((Object)1L)));
            Assert.assertThat((String)"Meter count is incorrect", (Object)((Meter)registry.getMeters().get(this.absoluteMetricName(1))).getCount(), (Matcher)Matchers.is((Matcher)Matchers.equalTo((Object)0L)));
            Assert.assertSame((String)"Exception thrown is incorrect", (Object)cause, (Object)exception);
            return;
        }
        Assert.fail((String)"No exception has been re-thrown!");
    }

    @Test
    public void callExceptionMeteredMethodOnceWithThrowingNonExpectedException() {
        Assert.assertThat((String)"Shared metric registry is not created", (Object)SharedMetricRegistries.names(), (Matcher)Matchers.hasItem((Object)REGISTRY_NAME));
        MetricRegistry registry = SharedMetricRegistries.getOrCreate((String)REGISTRY_NAME);
        Assert.assertThat((String)"Meters are not registered correctly", registry.getMeters().keySet(), (Matcher)Matchers.is((Matcher)Matchers.equalTo(this.absoluteMetricNames())));
        final IllegalStateException exception = new IllegalStateException("message");
        Runnable runnableThatThrowsIllegalStateException = new Runnable(){

            @Override
            public void run() {
                throw exception;
            }
        };
        try {
            this.instance.illegalArgumentExceptionMeteredMethod(runnableThatThrowsIllegalStateException);
        }
        catch (RuntimeException cause) {
            Assert.assertThat((String)"Meter counts are incorrect", registry.getMeters().values(), (Matcher)Matchers.everyItem((Matcher)Matchers.hasProperty((String)"count", (Matcher)Matchers.equalTo((Object)0L))));
            Assert.assertSame((String)"Exception thrown is incorrect", (Object)cause, (Object)exception);
            return;
        }
        Assert.fail((String)"No exception has been re-thrown!");
    }

    @Test
    public void callExceptionMeteredMethodOnceWithThrowingInstanceOfExpectedException() {
        Assert.assertThat((String)"Shared metric registry is not created", (Object)SharedMetricRegistries.names(), (Matcher)Matchers.hasItem((Object)REGISTRY_NAME));
        MetricRegistry registry = SharedMetricRegistries.getOrCreate((String)REGISTRY_NAME);
        Assert.assertThat((String)"Meters are not registered correctly", registry.getMeters().keySet(), (Matcher)Matchers.is((Matcher)Matchers.equalTo(this.absoluteMetricNames())));
        final IllegalStateException exception = new IllegalStateException("message");
        Runnable runnableThatThrowsIllegalStateException = new Runnable(){

            @Override
            public void run() {
                throw exception;
            }
        };
        try {
            this.instance.exceptionMeteredMethod(runnableThatThrowsIllegalStateException);
        }
        catch (RuntimeException cause) {
            Assert.assertThat((String)"Meter count is incorrect", (Object)((Meter)registry.getMeters().get(this.absoluteMetricName(0))).getCount(), (Matcher)Matchers.is((Matcher)Matchers.equalTo((Object)0L)));
            Assert.assertThat((String)"Meter count is incorrect", (Object)((Meter)registry.getMeters().get(this.absoluteMetricName(1))).getCount(), (Matcher)Matchers.is((Matcher)Matchers.equalTo((Object)1L)));
            Assert.assertSame((String)"Exception thrown is incorrect", (Object)cause, (Object)exception);
            return;
        }
        Assert.fail((String)"No exception has been re-thrown!");
    }
}

