/*
 * Decompiled with CFR 0.152.
 */
package io.astefanutti.metrics.aspectj.se;

import com.codahale.metrics.Gauge;
import com.codahale.metrics.MetricRegistry;
import com.codahale.metrics.SharedMetricRegistries;
import io.astefanutti.metrics.aspectj.se.GaugeStaticMethodWithRegistryFromString;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.junit.Assert;
import org.junit.Test;

public class GaugeStaticMethodWithRegistryFromStringTest {
    private static final String REGISTRY_NAME = "singleGaugeStaticRegistry";
    private static final String GAUGE_NAME = MetricRegistry.name(GaugeStaticMethodWithRegistryFromString.class, (String[])new String[]{"singleGaugeStaticMethod"});

    @Test
    public void callStaticGaugeAfterSetterCall() {
        long value = Math.round(Math.random() * 9.223372036854776E18);
        GaugeStaticMethodWithRegistryFromString.setSingleGauge((long)value);
        Assert.assertThat((String)"Shared metric registry is not created", (Object)SharedMetricRegistries.names(), (Matcher)Matchers.hasItem((Object)REGISTRY_NAME));
        MetricRegistry registry = SharedMetricRegistries.getOrCreate((String)REGISTRY_NAME);
        Assert.assertThat((String)"Gauge is not registered correctly", (Object)registry.getGauges(), (Matcher)Matchers.hasKey((Object)GAUGE_NAME));
        Gauge gauge = (Gauge)registry.getGauges().get(GAUGE_NAME);
        Assert.assertThat((String)"Gauge value is incorrect", (Object)gauge.getValue(), (Matcher)Matchers.is((Matcher)Matchers.equalTo((Object)value)));
    }
}

