/*
 * Decompiled with CFR 0.152.
 */
package io.astefanutti.metrics.aspectj.se;

import com.codahale.metrics.MetricRegistry;
import com.codahale.metrics.SharedMetricRegistries;
import io.astefanutti.metrics.aspectj.se.GaugeMethodWithVisibilityModifiers;
import io.astefanutti.metrics.aspectj.se.util.MetricsUtil;
import java.util.Set;
import org.fest.reflect.core.Reflection;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class GaugeMethodWithVisibilityModifiersTest {
    private static final String REGISTRY_NAME = "visibilityGaugeRegistry";
    private static final String[] GAUGE_NAMES = new String[]{"publicGaugeMethod", "packagePrivateGaugeMethod", "protectedGaugeMethod", "privateGaugeMethod"};
    private GaugeMethodWithVisibilityModifiers instance;

    private Set<String> absoluteMetricNames() {
        return MetricsUtil.absoluteMetricNames(GaugeMethodWithVisibilityModifiers.class, GAUGE_NAMES);
    }

    @Before
    public void createGaugeInstance() {
        this.instance = new GaugeMethodWithVisibilityModifiers();
    }

    @After
    public void clearSharedMetricRegistries() {
        SharedMetricRegistries.clear();
    }

    @Test
    public void gaugesCalledWithDefaultValues() {
        Assert.assertThat((String)"Shared metric registry is not created", (Object)SharedMetricRegistries.names(), (Matcher)Matchers.hasItem((Object)REGISTRY_NAME));
        MetricRegistry registry = SharedMetricRegistries.getOrCreate((String)REGISTRY_NAME);
        Assert.assertThat((String)"Gauges are not registered correctly", registry.getGauges().keySet(), (Matcher)Matchers.is((Matcher)Matchers.equalTo(this.absoluteMetricNames())));
        Assert.assertThat((String)"Gauge values are incorrect", registry.getGauges().values(), (Matcher)Matchers.everyItem((Matcher)Matchers.hasProperty((String)"value", (Matcher)Matchers.equalTo((Object)0L))));
    }

    @Test
    public void callGaugesAfterSetterCalls() {
        Assert.assertThat((String)"Shared metric registry is not created", (Object)SharedMetricRegistries.names(), (Matcher)Matchers.hasItem((Object)REGISTRY_NAME));
        MetricRegistry registry = SharedMetricRegistries.getOrCreate((String)REGISTRY_NAME);
        Assert.assertThat((String)"Gauges are not registered correctly", registry.getGauges().keySet(), (Matcher)Matchers.is((Matcher)Matchers.equalTo(this.absoluteMetricNames())));
        long value = Math.round(Math.random() * 9.223372036854776E18);
        this.instance.setPublicGauge(value);
        this.instance.setPackagePrivateGauge(value);
        this.instance.setProtectedGauge(value);
        Reflection.method((String)"setPrivateGauge").withParameterTypes(new Class[]{Long.TYPE}).in((Object)this.instance).invoke(new Object[]{value});
        Assert.assertThat((String)"Gauge values are incorrect", registry.getGauges().values(), (Matcher)Matchers.everyItem((Matcher)Matchers.hasProperty((String)"value", (Matcher)Matchers.equalTo((Object)value))));
    }
}

