/*
 * Decompiled with CFR 0.152.
 */
package io.astefanutti.metrics.aspectj.se;

import com.codahale.metrics.Gauge;
import com.codahale.metrics.MetricRegistry;
import com.codahale.metrics.SharedMetricRegistries;
import io.astefanutti.metrics.aspectj.se.GaugeMethodWithRegistryFromString;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class GaugeMethodWithRegistryFromStringTest {
    private static final String REGISTRY_NAME = "singleGaugeRegistry";
    private static final String GAUGE_NAME = MetricRegistry.name(GaugeMethodWithRegistryFromString.class, (String[])new String[]{"singleGaugeMethod"});
    private GaugeMethodWithRegistryFromString instance;

    @Before
    public void createGaugeInstance() {
        this.instance = new GaugeMethodWithRegistryFromString();
    }

    @After
    public void clearSharedMetricRegistries() {
        SharedMetricRegistries.clear();
    }

    @Test
    public void gaugeCalledWithDefaultValue() {
        Assert.assertThat((String)"Shared metric registry is not created", (Object)SharedMetricRegistries.names(), (Matcher)Matchers.hasItem((Object)REGISTRY_NAME));
        MetricRegistry registry = SharedMetricRegistries.getOrCreate((String)REGISTRY_NAME);
        Assert.assertThat((String)"Gauge is not registered correctly", (Object)registry.getGauges(), (Matcher)Matchers.hasKey((Object)GAUGE_NAME));
        Gauge gauge = (Gauge)registry.getGauges().get(GAUGE_NAME);
        Assert.assertThat((String)"Gauge value is incorrect", (Object)gauge.getValue(), (Matcher)Matchers.is((Matcher)Matchers.equalTo((Object)0L)));
    }

    @Test
    public void callGaugeAfterSetterCall() {
        Assert.assertThat((String)"Shared metric registry is not created", (Object)SharedMetricRegistries.names(), (Matcher)Matchers.hasItem((Object)REGISTRY_NAME));
        MetricRegistry registry = SharedMetricRegistries.getOrCreate((String)REGISTRY_NAME);
        Assert.assertThat((String)"Gauge is not registered correctly", (Object)registry.getGauges(), (Matcher)Matchers.hasKey((Object)GAUGE_NAME));
        Gauge gauge = (Gauge)registry.getGauges().get(GAUGE_NAME);
        long value = Math.round(Math.random() * 9.223372036854776E18);
        this.instance.setSingleGauge(value);
        Assert.assertThat((String)"Gauge value is incorrect", (Object)gauge.getValue(), (Matcher)Matchers.is((Matcher)Matchers.equalTo((Object)value)));
    }
}

