/*
 * Decompiled with CFR 0.152.
 */
package org.aspectj.lang.reflect;

import java.lang.ref.WeakReference;
import java.util.Collections;
import java.util.Map;
import java.util.WeakHashMap;
import org.aspectj.internal.lang.reflect.AjTypeImpl;
import org.aspectj.lang.reflect.AjType;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AjTypeSystem {
    private static Map<Class, WeakReference<AjType>> ajTypes = Collections.synchronizedMap(new WeakHashMap());

    public static <T> AjType<T> getAjType(Class<T> fromClass) {
        WeakReference<AjType> weakRefToAjType = ajTypes.get(fromClass);
        if (weakRefToAjType != null) {
            AjType theAjType = (AjType)weakRefToAjType.get();
            if (theAjType != null) {
                return theAjType;
            }
            theAjType = new AjTypeImpl(fromClass);
            ajTypes.put(fromClass, new WeakReference<AjType>(theAjType));
            return theAjType;
        }
        AjTypeImpl theAjType = new AjTypeImpl(fromClass);
        ajTypes.put(fromClass, new WeakReference<AjTypeImpl>(theAjType));
        return theAjType;
    }
}

