/*
 * Decompiled with CFR 0.152.
 */
package io.arkitik.travako.starter.spring.jpa.custom;

import com.zaxxer.hikari.HikariDataSource;
import io.arkitik.travako.adapter.leader.LeaderPortContext;
import io.arkitik.travako.port.job.JobInstancePortContext;
import io.arkitik.travako.port.job.event.JobEventPortContext;
import io.arkitik.travako.port.runner.RunnerPortContext;
import io.arkitik.travako.port.server.ServerPortContext;
import io.arkitik.travako.port.shared.SharedPortContext;
import javax.persistence.EntityManagerFactory;
import javax.sql.DataSource;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.boot.autoconfigure.jdbc.DataSourceProperties;
import org.springframework.boot.autoconfigure.orm.jpa.HibernateProperties;
import org.springframework.boot.autoconfigure.orm.jpa.HibernateSettings;
import org.springframework.boot.autoconfigure.orm.jpa.JpaProperties;
import org.springframework.boot.context.properties.ConfigurationProperties;
import org.springframework.boot.orm.jpa.EntityManagerFactoryBuilder;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Import;
import org.springframework.context.annotation.Primary;
import org.springframework.data.jpa.repository.config.EnableJpaRepositories;
import org.springframework.orm.jpa.JpaTransactionManager;
import org.springframework.orm.jpa.LocalContainerEntityManagerFactoryBean;
import org.springframework.transaction.PlatformTransactionManager;

@Configuration
@EnableJpaRepositories(basePackages={"io.arkitik.travako.adapter"}, entityManagerFactoryRef="travakoEntityManagerFactory", transactionManagerRef="travakoTransactionManager")
@Import(value={SharedPortContext.class, RunnerPortContext.class, JobInstancePortContext.class, ServerPortContext.class, LeaderPortContext.class, JobEventPortContext.class})
@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0017\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0017J\b\u0010\u0005\u001a\u00020\u0006H\u0017J*\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\b\b\u0001\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000eH\u0017J\u0010\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u000f\u001a\u00020\bH\u0017\u00a8\u0006\u0011"}, d2={"Lio/arkitik/travako/starter/spring/jpa/custom/CustomTravakoSpringJpaStarter;", "", "()V", "travakoAppDataSource", "Ljavax/sql/DataSource;", "travakoDataSourceProperties", "Lorg/springframework/boot/autoconfigure/jdbc/DataSourceProperties;", "travakoEntityManagerFactory", "Lorg/springframework/orm/jpa/LocalContainerEntityManagerFactoryBean;", "builder", "Lorg/springframework/boot/orm/jpa/EntityManagerFactoryBuilder;", "jpaProperties", "Lorg/springframework/boot/autoconfigure/orm/jpa/JpaProperties;", "hibernateProperties", "Lorg/springframework/boot/autoconfigure/orm/jpa/HibernateProperties;", "travakoTransactionManager", "Lorg/springframework/transaction/PlatformTransactionManager;", "travako-starter-spring-jpa-custom"})
public class CustomTravakoSpringJpaStarter {
    @Bean
    @ConfigurationProperties(value="arkitik.travako.database.datasource")
    @NotNull
    public DataSourceProperties travakoDataSourceProperties() {
        return new DataSourceProperties();
    }

    @Bean
    @Primary
    @NotNull
    public DataSource travakoAppDataSource(@NotNull DataSourceProperties travakoDataSourceProperties) {
        Intrinsics.checkNotNullParameter((Object)travakoDataSourceProperties, (String)"travakoDataSourceProperties");
        DataSource dataSource = travakoDataSourceProperties.initializeDataSourceBuilder().type(HikariDataSource.class).build();
        Intrinsics.checkNotNullExpressionValue((Object)dataSource, (String)"build(...)");
        return dataSource;
    }

    @Bean
    @Primary
    @NotNull
    public LocalContainerEntityManagerFactoryBean travakoEntityManagerFactory(@NotNull EntityManagerFactoryBuilder builder, @Qualifier(value="travakoAppDataSource") @NotNull DataSource travakoAppDataSource, @NotNull JpaProperties jpaProperties, @NotNull HibernateProperties hibernateProperties) {
        Intrinsics.checkNotNullParameter((Object)builder, (String)"builder");
        Intrinsics.checkNotNullParameter((Object)travakoAppDataSource, (String)"travakoAppDataSource");
        Intrinsics.checkNotNullParameter((Object)jpaProperties, (String)"jpaProperties");
        Intrinsics.checkNotNullParameter((Object)hibernateProperties, (String)"hibernateProperties");
        String[] stringArray = new String[]{"io.arkitik.travako.entity"};
        LocalContainerEntityManagerFactoryBean localContainerEntityManagerFactoryBean = builder.dataSource(travakoAppDataSource).properties(hibernateProperties.determineHibernateProperties(jpaProperties.getProperties(), new HibernateSettings().ddlAuto(() -> CustomTravakoSpringJpaStarter.travakoEntityManagerFactory$lambda$0(hibernateProperties)))).packages(stringArray).build();
        Intrinsics.checkNotNullExpressionValue((Object)localContainerEntityManagerFactoryBean, (String)"build(...)");
        return localContainerEntityManagerFactoryBean;
    }

    @Bean
    @Primary
    @NotNull
    public PlatformTransactionManager travakoTransactionManager(@NotNull LocalContainerEntityManagerFactoryBean travakoTransactionManager) {
        Intrinsics.checkNotNullParameter((Object)travakoTransactionManager, (String)"travakoTransactionManager");
        EntityManagerFactory entityManagerFactory = travakoTransactionManager.getObject();
        Intrinsics.checkNotNull((Object)entityManagerFactory);
        return (PlatformTransactionManager)new JpaTransactionManager(entityManagerFactory);
    }

    private static final String travakoEntityManagerFactory$lambda$0(HibernateProperties $hibernateProperties) {
        Intrinsics.checkNotNullParameter((Object)$hibernateProperties, (String)"$hibernateProperties");
        return $hibernateProperties.getDdlAuto();
    }
}

