/*
 * Decompiled with CFR 0.152.
 */
package io.arkitik.radix.tool.http;

import io.arkitik.radix.tool.http.RequestData;
import io.netty.channel.ChannelOption;
import java.util.ArrayList;
import java.util.List;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.Unit;
import kotlin.jvm.JvmClassMappingKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.reflect.KClass;
import org.jetbrains.annotations.NotNull;
import org.springframework.http.client.reactive.ClientHttpConnector;
import org.springframework.http.client.reactive.ReactorClientHttpConnector;
import org.springframework.web.reactive.function.BodyInserters;
import org.springframework.web.reactive.function.client.WebClient;
import reactor.core.publisher.Flux;
import reactor.netty.http.client.HttpClient;
import reactor.netty.transport.Transport;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000V\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0003\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\u0018\u0000 \"2\u00020\u0001:\u0001\"B\u000f\b\u0012\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004B\u000f\b\u0012\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\u0002\u0010\u0007JY\u0010\b\u001a\b\u0012\u0004\u0012\u0002H\n0\t\"\u0004\b\u0000\u0010\u000b\"\u0004\b\u0001\u0010\n2\u0006\u0010\f\u001a\u0002H\u000b2\u0006\u0010\r\u001a\u00020\u00032\f\u0010\u000e\u001a\b\u0012\u0004\u0012\u0002H\n0\u000f2\u001c\b\u0002\u0010\u0010\u001a\u0016\u0012\u0012\u0012\u0010\u0012\u0004\u0012\u00020\u0003\u0012\u0006\u0012\u0004\u0018\u00010\u00010\u00120\u0011\u00a2\u0006\u0002\u0010\u0013J\u0089\u0001\u0010\u0014\u001a\u00020\u0015\"\u0004\b\u0000\u0010\u000b\"\b\b\u0001\u0010\n*\u00020\u00012\u0006\u0010\f\u001a\u0002H\u000b2\u0006\u0010\r\u001a\u00020\u00032\u001a\u0010\u0010\u001a\u0016\u0012\u0012\u0012\u0010\u0012\u0004\u0012\u00020\u0003\u0012\u0006\u0012\u0004\u0018\u00010\u00010\u00120\u00112\f\u0010\u000e\u001a\b\u0012\u0004\u0012\u0002H\n0\u00162\u0019\u0010\u0017\u001a\u0015\u0012\u0006\u0012\u0004\u0018\u0001H\n\u0012\u0004\u0012\u00020\u00150\u0018\u00a2\u0006\u0002\b\u00192\u0017\u0010\u001a\u001a\u0013\u0012\u0004\u0012\u00020\u001b\u0012\u0004\u0012\u00020\u00150\u0018\u00a2\u0006\u0002\b\u0019\u00a2\u0006\u0002\u0010\u001cJf\u0010\u0014\u001a\u00020\u0015\"\u0004\b\u0000\u0010\u000b\"\b\b\u0001\u0010\n*\u00020\u00012\f\u0010\f\u001a\b\u0012\u0004\u0012\u0002H\u000b0\u001d2\f\u0010\u000e\u001a\b\u0012\u0004\u0012\u0002H\n0\u00162\u0019\u0010\u0017\u001a\u0015\u0012\u0006\u0012\u0004\u0018\u0001H\n\u0012\u0004\u0012\u00020\u00150\u0018\u00a2\u0006\u0002\b\u00192\u0017\u0010\u001a\u001a\u0013\u0012\u0004\u0012\u00020\u001b\u0012\u0004\u0012\u00020\u00150\u0018\u00a2\u0006\u0002\b\u0019JY\u0010\u001e\u001a\b\u0012\u0004\u0012\u0002H\n0\t\"\u0004\b\u0000\u0010\u000b\"\u0004\b\u0001\u0010\n2\u0006\u0010\f\u001a\u0002H\u000b2\u0006\u0010\r\u001a\u00020\u00032\f\u0010\u000e\u001a\b\u0012\u0004\u0012\u0002H\n0\u000f2\u001c\b\u0002\u0010\u0010\u001a\u0016\u0012\u0012\u0012\u0010\u0012\u0004\u0012\u00020\u0003\u0012\u0006\u0012\u0004\u0018\u00010\u00010\u00120\u0011\u00a2\u0006\u0002\u0010\u0013J\u0084\u0001\u0010\u001f\u001a\u00020\u0015\"\u0004\b\u0000\u0010\u000b\"\b\b\u0001\u0010\n*\u00020\u00012\u0006\u0010\f\u001a\u0002H\u000b2\u0006\u0010\r\u001a\u00020\u00032\u001a\u0010\u0010\u001a\u0016\u0012\u0012\u0012\u0010\u0012\u0004\u0012\u00020\u0003\u0012\u0006\u0012\u0004\u0018\u00010\u00010\u00120\u00112\f\u0010\u000e\u001a\b\u0012\u0004\u0012\u0002H\n0\u00162\u0014\u0010\u0017\u001a\u0010\u0012\u0006\u0012\u0004\u0018\u0001H\n\u0012\u0004\u0012\u00020\u00150\u00182\u0017\u0010\u001a\u001a\u0013\u0012\u0004\u0012\u00020\u001b\u0012\u0004\u0012\u00020\u00150\u0018\u00a2\u0006\u0002\b\u0019\u00a2\u0006\u0002\u0010\u001cJa\u0010\u001f\u001a\u00020\u0015\"\u0004\b\u0000\u0010\u000b\"\b\b\u0001\u0010\n*\u00020\u00012\f\u0010\f\u001a\b\u0012\u0004\u0012\u0002H\u000b0\u001d2\f\u0010\u000e\u001a\b\u0012\u0004\u0012\u0002H\n0\u00162\u0014\u0010\u0017\u001a\u0010\u0012\u0006\u0012\u0004\u0018\u0001H\n\u0012\u0004\u0012\u00020\u00150\u00182\u0017\u0010\u001a\u001a\u0013\u0012\u0004\u0012\u00020\u001b\u0012\u0004\u0012\u00020\u00150\u0018\u00a2\u0006\u0002\b\u0019JY\u0010 \u001a\b\u0012\u0004\u0012\u0002H\n0\t\"\u0004\b\u0000\u0010\u000b\"\u0004\b\u0001\u0010\n2\u0006\u0010\f\u001a\u0002H\u000b2\u0006\u0010\r\u001a\u00020\u00032\f\u0010\u000e\u001a\b\u0012\u0004\u0012\u0002H\n0\u000f2\u001c\b\u0002\u0010\u0010\u001a\u0016\u0012\u0012\u0012\u0010\u0012\u0004\u0012\u00020\u0003\u0012\u0006\u0012\u0004\u0018\u00010\u00010\u00120\u0011\u00a2\u0006\u0002\u0010\u0013J\u0089\u0001\u0010!\u001a\u00020\u0015\"\u0004\b\u0000\u0010\u000b\"\b\b\u0001\u0010\n*\u00020\u00012\u0006\u0010\f\u001a\u0002H\u000b2\u0006\u0010\r\u001a\u00020\u00032\u001a\u0010\u0010\u001a\u0016\u0012\u0012\u0012\u0010\u0012\u0004\u0012\u00020\u0003\u0012\u0006\u0012\u0004\u0018\u00010\u00010\u00120\u00112\f\u0010\u000e\u001a\b\u0012\u0004\u0012\u0002H\n0\u00162\u0019\u0010\u0017\u001a\u0015\u0012\u0006\u0012\u0004\u0018\u0001H\n\u0012\u0004\u0012\u00020\u00150\u0018\u00a2\u0006\u0002\b\u00192\u0017\u0010\u001a\u001a\u0013\u0012\u0004\u0012\u00020\u001b\u0012\u0004\u0012\u00020\u00150\u0018\u00a2\u0006\u0002\b\u0019\u00a2\u0006\u0002\u0010\u001cJf\u0010!\u001a\u00020\u0015\"\u0004\b\u0000\u0010\u000b\"\b\b\u0001\u0010\n*\u00020\u00012\f\u0010\f\u001a\b\u0012\u0004\u0012\u0002H\u000b0\u001d2\f\u0010\u000e\u001a\b\u0012\u0004\u0012\u0002H\n0\u00162\u0019\u0010\u0017\u001a\u0015\u0012\u0006\u0012\u0004\u0018\u0001H\n\u0012\u0004\u0012\u00020\u00150\u0018\u00a2\u0006\u0002\b\u00192\u0017\u0010\u001a\u001a\u0013\u0012\u0004\u0012\u00020\u001b\u0012\u0004\u0012\u00020\u00150\u0018\u00a2\u0006\u0002\b\u0019R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006#"}, d2={"Lio/arkitik/radix/tool/http/HttpRequestProcessor;", "", "rootUrl", "", "(Ljava/lang/String;)V", "webClient", "Lorg/springframework/web/reactive/function/client/WebClient;", "(Lorg/springframework/web/reactive/function/client/WebClient;)V", "patch", "Lreactor/core/publisher/Flux;", "RS", "T", "request", "mapping", "responseClass", "Ljava/lang/Class;", "headers", "", "Lkotlin/Pair;", "(Ljava/lang/Object;Ljava/lang/String;Ljava/lang/Class;Ljava/util/List;)Lreactor/core/publisher/Flux;", "patchBlocking", "", "Lkotlin/reflect/KClass;", "subscription", "Lkotlin/Function1;", "Lkotlin/ExtensionFunctionType;", "errorHandler", "", "(Ljava/lang/Object;Ljava/lang/String;Ljava/util/List;Lkotlin/reflect/KClass;Lkotlin/jvm/functions/Function1;Lkotlin/jvm/functions/Function1;)V", "Lio/arkitik/radix/tool/http/RequestData;", "post", "postBlocking", "put", "putBlocking", "Companion", "radix-tool-http"})
public final class HttpRequestProcessor {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final WebClient webClient;

    private HttpRequestProcessor(String rootUrl) {
        Transport transport = HttpClient.create().option(ChannelOption.SO_KEEPALIVE, (Object)true);
        Intrinsics.checkNotNullExpressionValue((Object)transport, (String)"create()\n            .op\u2026ption.SO_KEEPALIVE, true)");
        HttpClient httpClient = (HttpClient)transport;
        String[] stringArray = new String[]{"timeout=5"};
        WebClient webClient = WebClient.builder().clientConnector((ClientHttpConnector)new ReactorClientHttpConnector(httpClient)).defaultHeader("Keep-Alive", stringArray).baseUrl(rootUrl).build();
        Intrinsics.checkNotNullExpressionValue((Object)webClient, (String)"builder()\n            .c\u2026Url)\n            .build()");
        this.webClient = webClient;
    }

    private HttpRequestProcessor(WebClient webClient) {
        this.webClient = webClient;
    }

    public final <T, RS> void postBlocking(@NotNull RequestData<T> request, @NotNull KClass<RS> responseClass, @NotNull Function1<? super RS, Unit> subscription, @NotNull Function1<? super Throwable, Unit> errorHandler) {
        Intrinsics.checkNotNullParameter(request, (String)"request");
        Intrinsics.checkNotNullParameter(responseClass, (String)"responseClass");
        Intrinsics.checkNotNullParameter(subscription, (String)"subscription");
        Intrinsics.checkNotNullParameter(errorHandler, (String)"errorHandler");
        this.postBlocking(request.getBody(), request.getMapping(), request.getHeaders(), responseClass, subscription, errorHandler);
    }

    public final <T, RS> void postBlocking(T request, @NotNull String mapping, @NotNull List<? extends Pair<String, ? extends Object>> headers, @NotNull KClass<RS> responseClass, @NotNull Function1<? super RS, Unit> subscription, @NotNull Function1<? super Throwable, Unit> errorHandler) {
        Intrinsics.checkNotNullParameter((Object)mapping, (String)"mapping");
        Intrinsics.checkNotNullParameter(headers, (String)"headers");
        Intrinsics.checkNotNullParameter(responseClass, (String)"responseClass");
        Intrinsics.checkNotNullParameter(subscription, (String)"subscription");
        Intrinsics.checkNotNullParameter(errorHandler, (String)"errorHandler");
        try {
            Object response = this.post(request, mapping, JvmClassMappingKt.getJavaClass(responseClass), headers).blockFirst();
            subscription.invoke(response);
        }
        catch (Throwable e) {
            errorHandler.invoke((Object)e);
        }
    }

    public final <T, RS> void patchBlocking(@NotNull RequestData<T> request, @NotNull KClass<RS> responseClass, @NotNull Function1<? super RS, Unit> subscription, @NotNull Function1<? super Throwable, Unit> errorHandler) {
        Intrinsics.checkNotNullParameter(request, (String)"request");
        Intrinsics.checkNotNullParameter(responseClass, (String)"responseClass");
        Intrinsics.checkNotNullParameter(subscription, (String)"subscription");
        Intrinsics.checkNotNullParameter(errorHandler, (String)"errorHandler");
        this.patchBlocking(request.getBody(), request.getMapping(), request.getHeaders(), responseClass, subscription, errorHandler);
    }

    public final <T, RS> void patchBlocking(T request, @NotNull String mapping, @NotNull List<? extends Pair<String, ? extends Object>> headers, @NotNull KClass<RS> responseClass, @NotNull Function1<? super RS, Unit> subscription, @NotNull Function1<? super Throwable, Unit> errorHandler) {
        Intrinsics.checkNotNullParameter((Object)mapping, (String)"mapping");
        Intrinsics.checkNotNullParameter(headers, (String)"headers");
        Intrinsics.checkNotNullParameter(responseClass, (String)"responseClass");
        Intrinsics.checkNotNullParameter(subscription, (String)"subscription");
        Intrinsics.checkNotNullParameter(errorHandler, (String)"errorHandler");
        try {
            Object response = this.patch(request, mapping, JvmClassMappingKt.getJavaClass(responseClass), headers).blockFirst();
            subscription.invoke(response);
        }
        catch (Throwable e) {
            errorHandler.invoke((Object)e);
        }
    }

    public final <T, RS> void putBlocking(@NotNull RequestData<T> request, @NotNull KClass<RS> responseClass, @NotNull Function1<? super RS, Unit> subscription, @NotNull Function1<? super Throwable, Unit> errorHandler) {
        Intrinsics.checkNotNullParameter(request, (String)"request");
        Intrinsics.checkNotNullParameter(responseClass, (String)"responseClass");
        Intrinsics.checkNotNullParameter(subscription, (String)"subscription");
        Intrinsics.checkNotNullParameter(errorHandler, (String)"errorHandler");
        this.putBlocking(request.getBody(), request.getMapping(), request.getHeaders(), responseClass, subscription, errorHandler);
    }

    public final <T, RS> void putBlocking(T request, @NotNull String mapping, @NotNull List<? extends Pair<String, ? extends Object>> headers, @NotNull KClass<RS> responseClass, @NotNull Function1<? super RS, Unit> subscription, @NotNull Function1<? super Throwable, Unit> errorHandler) {
        Intrinsics.checkNotNullParameter((Object)mapping, (String)"mapping");
        Intrinsics.checkNotNullParameter(headers, (String)"headers");
        Intrinsics.checkNotNullParameter(responseClass, (String)"responseClass");
        Intrinsics.checkNotNullParameter(subscription, (String)"subscription");
        Intrinsics.checkNotNullParameter(errorHandler, (String)"errorHandler");
        try {
            Object response = this.put(request, mapping, JvmClassMappingKt.getJavaClass(responseClass), headers).blockFirst();
            subscription.invoke(response);
        }
        catch (Throwable e) {
            errorHandler.invoke((Object)e);
        }
    }

    @NotNull
    public final <T, RS> Flux<RS> post(T request, @NotNull String mapping, @NotNull Class<RS> responseClass, @NotNull List<? extends Pair<String, ? extends Object>> headers) {
        Intrinsics.checkNotNullParameter((Object)mapping, (String)"mapping");
        Intrinsics.checkNotNullParameter(responseClass, (String)"responseClass");
        Intrinsics.checkNotNullParameter(headers, (String)"headers");
        WebClient.RequestHeadersSpec requestHeadersSpec = this.webClient.post().uri('/' + mapping, new Object[0]);
        Intrinsics.checkNotNullExpressionValue((Object)requestHeadersSpec, (String)"webClient.post()\n            .uri(\"/$mapping\")");
        WebClient.RequestBodySpec requestBodySpec = (WebClient.RequestBodySpec)requestHeadersSpec;
        Iterable $this$forEach$iv = headers;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            Pair it = (Pair)element$iv;
            boolean bl = false;
            String[] stringArray = new String[1];
            Object object = it.getSecond();
            stringArray[0] = object != null ? object.toString() : null;
            requestBodySpec.header((String)it.getFirst(), stringArray);
        }
        Flux flux = requestBodySpec.body(BodyInserters.fromValue(request)).retrieve().bodyToFlux(responseClass);
        Intrinsics.checkNotNullExpressionValue((Object)flux, (String)"requestBodySpec\n        \u2026bodyToFlux(responseClass)");
        return flux;
    }

    public static /* synthetic */ Flux post$default(HttpRequestProcessor httpRequestProcessor, Object object, String string, Class clazz, List list, int n, Object object2) {
        if ((n & 8) != 0) {
            list = new ArrayList();
        }
        return httpRequestProcessor.post(object, string, clazz, list);
    }

    @NotNull
    public final <T, RS> Flux<RS> patch(T request, @NotNull String mapping, @NotNull Class<RS> responseClass, @NotNull List<? extends Pair<String, ? extends Object>> headers) {
        Intrinsics.checkNotNullParameter((Object)mapping, (String)"mapping");
        Intrinsics.checkNotNullParameter(responseClass, (String)"responseClass");
        Intrinsics.checkNotNullParameter(headers, (String)"headers");
        WebClient.RequestHeadersSpec requestHeadersSpec = this.webClient.patch().uri('/' + mapping, new Object[0]);
        Intrinsics.checkNotNullExpressionValue((Object)requestHeadersSpec, (String)"webClient.patch()\n            .uri(\"/$mapping\")");
        WebClient.RequestBodySpec requestBodySpec = (WebClient.RequestBodySpec)requestHeadersSpec;
        Iterable $this$forEach$iv = headers;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            Pair it = (Pair)element$iv;
            boolean bl = false;
            String[] stringArray = new String[1];
            Object object = it.getSecond();
            stringArray[0] = object != null ? object.toString() : null;
            requestBodySpec.header((String)it.getFirst(), stringArray);
        }
        Flux flux = requestBodySpec.body(BodyInserters.fromValue(request)).retrieve().bodyToFlux(responseClass);
        Intrinsics.checkNotNullExpressionValue((Object)flux, (String)"requestBodySpec\n        \u2026bodyToFlux(responseClass)");
        return flux;
    }

    public static /* synthetic */ Flux patch$default(HttpRequestProcessor httpRequestProcessor, Object object, String string, Class clazz, List list, int n, Object object2) {
        if ((n & 8) != 0) {
            list = new ArrayList();
        }
        return httpRequestProcessor.patch(object, string, clazz, list);
    }

    @NotNull
    public final <T, RS> Flux<RS> put(T request, @NotNull String mapping, @NotNull Class<RS> responseClass, @NotNull List<? extends Pair<String, ? extends Object>> headers) {
        Intrinsics.checkNotNullParameter((Object)mapping, (String)"mapping");
        Intrinsics.checkNotNullParameter(responseClass, (String)"responseClass");
        Intrinsics.checkNotNullParameter(headers, (String)"headers");
        WebClient.RequestHeadersSpec requestHeadersSpec = this.webClient.put().uri('/' + mapping, new Object[0]);
        Intrinsics.checkNotNullExpressionValue((Object)requestHeadersSpec, (String)"webClient.put()\n            .uri(\"/$mapping\")");
        WebClient.RequestBodySpec requestBodySpec = (WebClient.RequestBodySpec)requestHeadersSpec;
        Iterable $this$forEach$iv = headers;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            Pair it = (Pair)element$iv;
            boolean bl = false;
            String[] stringArray = new String[1];
            Object object = it.getSecond();
            stringArray[0] = object != null ? object.toString() : null;
            requestBodySpec.header((String)it.getFirst(), stringArray);
        }
        Flux flux = requestBodySpec.body(BodyInserters.fromValue(request)).retrieve().bodyToFlux(responseClass);
        Intrinsics.checkNotNullExpressionValue((Object)flux, (String)"requestBodySpec\n        \u2026bodyToFlux(responseClass)");
        return flux;
    }

    public static /* synthetic */ Flux put$default(HttpRequestProcessor httpRequestProcessor, Object object, String string, Class clazz, List list, int n, Object object2) {
        if ((n & 8) != 0) {
            list = new ArrayList();
        }
        return httpRequestProcessor.put(object, string, clazz, list);
    }

    public /* synthetic */ HttpRequestProcessor(String rootUrl, DefaultConstructorMarker $constructor_marker) {
        this(rootUrl);
    }

    public /* synthetic */ HttpRequestProcessor(WebClient webClient, DefaultConstructorMarker $constructor_marker) {
        this(webClient);
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u000e\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006J\u000e\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0007\u001a\u00020\b\u00a8\u0006\t"}, d2={"Lio/arkitik/radix/tool/http/HttpRequestProcessor$Companion;", "", "()V", "from", "Lio/arkitik/radix/tool/http/HttpRequestProcessor;", "rootUrl", "", "webClient", "Lorg/springframework/web/reactive/function/client/WebClient;", "radix-tool-http"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final HttpRequestProcessor from(@NotNull String rootUrl) {
            Intrinsics.checkNotNullParameter((Object)rootUrl, (String)"rootUrl");
            return new HttpRequestProcessor(rootUrl, null);
        }

        @NotNull
        public final HttpRequestProcessor from(@NotNull WebClient webClient) {
            Intrinsics.checkNotNullParameter((Object)webClient, (String)"webClient");
            return new HttpRequestProcessor(webClient, null);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

