/*
 * Decompiled with CFR 0.152.
 */
package io.arkitik.radix.adapter.shared.query;

import io.arkitik.radix.adapter.shared.Spring_data_store_extKt;
import io.arkitik.radix.adapter.shared.repository.RadixRepository;
import io.arkitik.radix.develop.identity.Identity;
import io.arkitik.radix.develop.store.query.PageData;
import io.arkitik.radix.develop.store.query.StoreQuery;
import java.io.Serializable;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.springframework.data.domain.PageRequest;
import org.springframework.data.domain.Pageable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000B\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\u001c\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0005\b\u0016\u0018\u0000*\b\b\u0000\u0010\u0001*\u00020\u0002*\u000e\b\u0001\u0010\u0003*\b\u0012\u0004\u0012\u0002H\u00010\u0004*\b\b\u0002\u0010\u0005*\u0002H\u00032\u000e\u0012\u0004\u0012\u0002H\u0001\u0012\u0004\u0012\u0002H\u00030\u0006B\u0019\u0012\u0012\u0010\u0007\u001a\u000e\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00028\u00020\b\u00a2\u0006\u0002\u0010\tJ\u000e\u0010\n\u001a\b\u0012\u0004\u0012\u00028\u00010\u000bH\u0016J\u001e\u0010\n\u001a\b\u0012\u0004\u0012\u00028\u00010\f2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u000eH\u0016J\u001c\u0010\u0010\u001a\b\u0012\u0004\u0012\u00028\u00010\u00112\f\u0010\u0012\u001a\b\u0012\u0004\u0012\u00028\u00000\u000bH\u0016J\u0015\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00028\u0000H\u0016\u00a2\u0006\u0002\u0010\u0016J\u0017\u0010\u0017\u001a\u0004\u0018\u00018\u00012\u0006\u0010\u0015\u001a\u00028\u0000H\u0016\u00a2\u0006\u0002\u0010\u0018R\u001a\u0010\u0007\u001a\u000e\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00028\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0019"}, d2={"Lio/arkitik/radix/adapter/shared/query/StoreQueryImpl;", "ID", "Ljava/io/Serializable;", "I", "Lio/arkitik/radix/develop/identity/Identity;", "E", "Lio/arkitik/radix/develop/store/query/StoreQuery;", "repository", "Lio/arkitik/radix/adapter/shared/repository/RadixRepository;", "(Lio/arkitik/radix/adapter/shared/repository/RadixRepository;)V", "all", "", "Lio/arkitik/radix/develop/store/query/PageData;", "page", "", "size", "allByUuids", "", "uuids", "exist", "", "uuid", "(Ljava/io/Serializable;)Z", "find", "(Ljava/io/Serializable;)Lio/arkitik/radix/develop/identity/Identity;", "radix-adapter-shared"})
public class StoreQueryImpl<ID extends Serializable, I extends Identity<ID>, E extends I>
implements StoreQuery<ID, I> {
    @NotNull
    private final RadixRepository<ID, E> repository;

    public StoreQueryImpl(@NotNull RadixRepository<ID, E> repository) {
        Intrinsics.checkNotNullParameter(repository, (String)"repository");
        this.repository = repository;
    }

    @Nullable
    public I find(@NotNull ID uuid) {
        Intrinsics.checkNotNullParameter(uuid, (String)"uuid");
        return (I)this.repository.findByUuid(uuid);
    }

    public boolean exist(@NotNull ID uuid) {
        Intrinsics.checkNotNullParameter(uuid, (String)"uuid");
        return this.repository.existsById(uuid);
    }

    @NotNull
    public Iterable<I> allByUuids(@NotNull List<? extends ID> uuids) {
        Intrinsics.checkNotNullParameter(uuids, (String)"uuids");
        Iterable iterable = this.repository.findAllById(uuids);
        Intrinsics.checkNotNullExpressionValue((Object)iterable, (String)"findAllById(...)");
        return iterable;
    }

    @NotNull
    public List<I> all() {
        Iterable iterable = this.repository.findAll();
        Intrinsics.checkNotNullExpressionValue((Object)iterable, (String)"findAll(...)");
        return CollectionsKt.toList((Iterable)iterable);
    }

    @NotNull
    public PageData<I> all(int page, int size) {
        StoreQuery storeQuery = this;
        PageRequest pageRequest = PageRequest.of((int)page, (int)size);
        Intrinsics.checkNotNullExpressionValue((Object)pageRequest, (String)"of(...)");
        return Spring_data_store_extKt.paged(storeQuery, this.repository.findAll((Pageable)pageRequest));
    }
}

