/*
 * Decompiled with CFR 0.152.
 */
package io.arconia.opentelemetry.testcontainers;

import io.arconia.opentelemetry.autoconfigure.exporter.otlp.Protocol;
import io.arconia.opentelemetry.autoconfigure.traces.exporter.otlp.OtlpTracingConnectionDetails;
import io.arconia.opentelemetry.autoconfigure.traces.exporter.otlp.OtlpTracingExporterConfiguration;
import org.springframework.boot.testcontainers.service.connection.ContainerConnectionDetailsFactory;
import org.springframework.boot.testcontainers.service.connection.ContainerConnectionSource;
import org.testcontainers.grafana.LgtmStackContainer;

class LgtmOtlpTracingContainerConnectionDetailsFactory
extends ContainerConnectionDetailsFactory<LgtmStackContainer, OtlpTracingConnectionDetails> {
    LgtmOtlpTracingContainerConnectionDetailsFactory() {
        super(ANY_CONNECTION_NAME, new String[]{OtlpTracingExporterConfiguration.class.getName()});
    }

    protected OtlpTracingConnectionDetails getContainerConnectionDetails(ContainerConnectionSource<LgtmStackContainer> source) {
        return new LgtmOpenTelemetryTracingContainerConnectionDetails(source);
    }

    private static final class LgtmOpenTelemetryTracingContainerConnectionDetails
    extends ContainerConnectionDetailsFactory.ContainerConnectionDetails<LgtmStackContainer>
    implements OtlpTracingConnectionDetails {
        private LgtmOpenTelemetryTracingContainerConnectionDetails(ContainerConnectionSource<LgtmStackContainer> source) {
            super(source);
        }

        @Override
        public String getUrl(Protocol protocol) {
            String url = switch (protocol) {
                default -> throw new MatchException(null, null);
                case Protocol.HTTP_PROTOBUF -> ((LgtmStackContainer)this.getContainer()).getOtlpHttpUrl();
                case Protocol.GRPC -> ((LgtmStackContainer)this.getContainer()).getOtlpGrpcUrl();
            };
            return protocol == Protocol.HTTP_PROTOBUF ? url + "/v1/traces" : url;
        }
    }
}

