/*
 * Decompiled with CFR 0.152.
 */
package io.arconia.opentelemetry.testcontainers;

import io.arconia.opentelemetry.autoconfigure.exporter.otlp.Protocol;
import io.arconia.opentelemetry.autoconfigure.logs.exporter.otlp.OtlpLoggingConnectionDetails;
import io.arconia.opentelemetry.autoconfigure.logs.exporter.otlp.OtlpLoggingExporterConfiguration;
import org.springframework.boot.testcontainers.service.connection.ContainerConnectionDetailsFactory;
import org.springframework.boot.testcontainers.service.connection.ContainerConnectionSource;
import org.testcontainers.grafana.LgtmStackContainer;

class LgtmOtlpLoggingContainerConnectionDetailsFactory
extends ContainerConnectionDetailsFactory<LgtmStackContainer, OtlpLoggingConnectionDetails> {
    LgtmOtlpLoggingContainerConnectionDetailsFactory() {
        super(ANY_CONNECTION_NAME, new String[]{OtlpLoggingExporterConfiguration.class.getName()});
    }

    protected OtlpLoggingConnectionDetails getContainerConnectionDetails(ContainerConnectionSource<LgtmStackContainer> source) {
        return new LgtmOpenTelemetryLoggingContainerConnectionDetails(source);
    }

    private static final class LgtmOpenTelemetryLoggingContainerConnectionDetails
    extends ContainerConnectionDetailsFactory.ContainerConnectionDetails<LgtmStackContainer>
    implements OtlpLoggingConnectionDetails {
        private LgtmOpenTelemetryLoggingContainerConnectionDetails(ContainerConnectionSource<LgtmStackContainer> source) {
            super(source);
        }

        @Override
        public String getUrl(Protocol protocol) {
            String url = switch (protocol) {
                default -> throw new MatchException(null, null);
                case Protocol.HTTP_PROTOBUF -> ((LgtmStackContainer)this.getContainer()).getOtlpHttpUrl();
                case Protocol.GRPC -> ((LgtmStackContainer)this.getContainer()).getOtlpGrpcUrl();
            };
            return protocol == Protocol.HTTP_PROTOBUF ? url + "/v1/logs" : url;
        }
    }
}

