/*
 * Decompiled with CFR 0.152.
 */
package io.arconia.opentelemetry.autoconfigure.traces.exporter;

import io.arconia.opentelemetry.autoconfigure.exporter.ExporterType;
import io.arconia.opentelemetry.autoconfigure.traces.exporter.ConditionalOnOpenTelemetryTracingExporter;
import java.util.Map;
import org.springframework.boot.autoconfigure.condition.ConditionMessage;
import org.springframework.boot.autoconfigure.condition.ConditionOutcome;
import org.springframework.boot.autoconfigure.condition.SpringBootCondition;
import org.springframework.context.annotation.ConditionContext;
import org.springframework.core.type.AnnotatedTypeMetadata;
import org.springframework.util.StringUtils;

class OnOpenTelemetryTracingExporterCondition
extends SpringBootCondition {
    private static final String GENERAL_EXPORTER_TYPE = "arconia.otel.exporter.type";
    private static final String TRACES_EXPORTER_TYPE = "arconia.otel.traces.exporter.type";

    OnOpenTelemetryTracingExporterCondition() {
    }

    public ConditionOutcome getMatchOutcome(ConditionContext context, AnnotatedTypeMetadata metadata) {
        ExporterType tracesExporterType;
        String requestedExporterType;
        Map attributes = metadata.getAnnotationAttributes(ConditionalOnOpenTelemetryTracingExporter.class.getName());
        String string = requestedExporterType = attributes != null ? (String)attributes.get("value") : null;
        if (!StringUtils.hasText((String)requestedExporterType)) {
            return ConditionOutcome.noMatch((ConditionMessage)ConditionMessage.forCondition(ConditionalOnOpenTelemetryTracingExporter.class, (Object[])new Object[0]).because("a valid exporter type is not specified"));
        }
        String generalExporterTypeString = context.getEnvironment().getProperty(GENERAL_EXPORTER_TYPE, "otlp");
        ExporterType generalExporterType = StringUtils.hasText((String)generalExporterTypeString) ? ExporterType.valueOf(generalExporterTypeString.toUpperCase()) : null;
        String tracesExporterTypeString = (String)context.getEnvironment().getProperty(TRACES_EXPORTER_TYPE, String.class);
        ExporterType exporterType = tracesExporterType = StringUtils.hasText((String)tracesExporterTypeString) ? ExporterType.valueOf(tracesExporterTypeString.toUpperCase()) : null;
        if (tracesExporterType != null) {
            if (tracesExporterType.toString().equalsIgnoreCase(requestedExporterType)) {
                return ConditionOutcome.match((ConditionMessage)ConditionMessage.forCondition(ConditionalOnOpenTelemetryTracingExporter.class, (Object[])new Object[0]).because("arconia.otel.traces.exporter.type is set to " + String.valueOf((Object)tracesExporterType)));
            }
            return ConditionOutcome.noMatch((ConditionMessage)ConditionMessage.forCondition(ConditionalOnOpenTelemetryTracingExporter.class, (Object[])new Object[0]).because("arconia.otel.traces.exporter.type is set to " + String.valueOf((Object)tracesExporterType) + ", but requested " + requestedExporterType));
        }
        if (generalExporterType != null) {
            if (generalExporterType.toString().equalsIgnoreCase(requestedExporterType)) {
                return ConditionOutcome.match((ConditionMessage)ConditionMessage.forCondition(ConditionalOnOpenTelemetryTracingExporter.class, (Object[])new Object[0]).because("arconia.otel.exporter.type is set to " + String.valueOf((Object)generalExporterType)));
            }
            return ConditionOutcome.noMatch((ConditionMessage)ConditionMessage.forCondition(ConditionalOnOpenTelemetryTracingExporter.class, (Object[])new Object[0]).because("arconia.otel.exporter.type is set to " + String.valueOf((Object)generalExporterType) + ", but requested " + requestedExporterType));
        }
        return ConditionOutcome.noMatch((ConditionMessage)ConditionMessage.forCondition(ConditionalOnOpenTelemetryTracingExporter.class, (Object[])new Object[0]).because("exporter type not enabled: " + requestedExporterType));
    }
}

