/*
 * Decompiled with CFR 0.152.
 */
package io.arconia.opentelemetry.autoconfigure.traces;

import java.time.Duration;
import org.springframework.boot.context.properties.ConfigurationProperties;

@ConfigurationProperties(prefix="arconia.otel.traces")
public class OpenTelemetryTracingProperties {
    public static final String CONFIG_PREFIX = "arconia.otel.traces";
    private final Sampling sampling = new Sampling();
    private final SpanLimits limits = new SpanLimits();
    private final SpanProcessorConfig processor = new SpanProcessorConfig();

    public Sampling getSampling() {
        return this.sampling;
    }

    public SpanLimits getLimits() {
        return this.limits;
    }

    public SpanProcessorConfig getProcessor() {
        return this.processor;
    }

    public static class Sampling {
        private SamplingStrategy strategy = SamplingStrategy.PARENT_BASED_ALWAYS_ON;

        public SamplingStrategy getStrategy() {
            return this.strategy;
        }

        public void setStrategy(SamplingStrategy strategy) {
            this.strategy = strategy;
        }
    }

    public static class SpanLimits {
        private int maxAttributeValueLength = Integer.MAX_VALUE;
        private int maxNumberOfAttributes = 128;
        private int maxNumberOfEvents = 128;
        private int maxNumberOfLinks = 128;
        private int maxNumberOfAttributesPerEvent = 128;
        private int maxNumberOfAttributesPerLink = 128;

        public int getMaxAttributeValueLength() {
            return this.maxAttributeValueLength;
        }

        public void setMaxAttributeValueLength(int maxAttributeValueLength) {
            this.maxAttributeValueLength = maxAttributeValueLength;
        }

        public int getMaxNumberOfAttributes() {
            return this.maxNumberOfAttributes;
        }

        public void setMaxNumberOfAttributes(int maxNumberOfAttributes) {
            this.maxNumberOfAttributes = maxNumberOfAttributes;
        }

        public int getMaxNumberOfEvents() {
            return this.maxNumberOfEvents;
        }

        public void setMaxNumberOfEvents(int maxNumberOfEvents) {
            this.maxNumberOfEvents = maxNumberOfEvents;
        }

        public int getMaxNumberOfLinks() {
            return this.maxNumberOfLinks;
        }

        public void setMaxNumberOfLinks(int maxNumberOfLinks) {
            this.maxNumberOfLinks = maxNumberOfLinks;
        }

        public int getMaxNumberOfAttributesPerEvent() {
            return this.maxNumberOfAttributesPerEvent;
        }

        public void setMaxNumberOfAttributesPerEvent(int maxNumberOfAttributesPerEvent) {
            this.maxNumberOfAttributesPerEvent = maxNumberOfAttributesPerEvent;
        }

        public int getMaxNumberOfAttributesPerLink() {
            return this.maxNumberOfAttributesPerLink;
        }

        public void setMaxNumberOfAttributesPerLink(int maxNumberOfAttributesPerLink) {
            this.maxNumberOfAttributesPerLink = maxNumberOfAttributesPerLink;
        }
    }

    public static class SpanProcessorConfig {
        private Duration scheduleDelay = Duration.ofSeconds(5L);
        private Duration exportTimeout = Duration.ofSeconds(30L);
        private int maxQueueSize = 2048;
        private int maxExportBatchSize = 512;
        private boolean exportUnsampledSpans = false;
        private boolean metrics = false;

        public Duration getScheduleDelay() {
            return this.scheduleDelay;
        }

        public void setScheduleDelay(Duration scheduleDelay) {
            this.scheduleDelay = scheduleDelay;
        }

        public Duration getExportTimeout() {
            return this.exportTimeout;
        }

        public void setExportTimeout(Duration exporterTimeout) {
            this.exportTimeout = exporterTimeout;
        }

        public int getMaxQueueSize() {
            return this.maxQueueSize;
        }

        public void setMaxQueueSize(int maxQueueSize) {
            this.maxQueueSize = maxQueueSize;
        }

        public int getMaxExportBatchSize() {
            return this.maxExportBatchSize;
        }

        public void setMaxExportBatchSize(int maxExportBatchSize) {
            this.maxExportBatchSize = maxExportBatchSize;
        }

        public boolean isExportUnsampledSpans() {
            return this.exportUnsampledSpans;
        }

        public void setExportUnsampledSpans(boolean exportUnsampledSpans) {
            this.exportUnsampledSpans = exportUnsampledSpans;
        }

        public boolean isMetrics() {
            return this.metrics;
        }

        public void setMetrics(boolean metrics) {
            this.metrics = metrics;
        }
    }

    public static enum SamplingStrategy {
        ALWAYS_ON,
        ALWAYS_OFF,
        TRACE_ID_RATIO,
        PARENT_BASED_ALWAYS_ON,
        PARENT_BASED_ALWAYS_OFF,
        PARENT_BASED_TRACE_ID_RATIO;

    }
}

